/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch.join;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.Join;
import cn.wjybxx.btree.branch.JoinPolicy;
import cn.wjybxx.btree.branch.ParallelBranch;
import cn.wjybxx.btree.branch.ParallelChildHelper;

public class JoinMain<T>
implements JoinPolicy<T> {
    private static final JoinMain<?> INSTANCE = new JoinMain();

    public static <T> JoinMain<T> getInstance() {
        return INSTANCE;
    }

    @Override
    public void resetForRestart() {
    }

    @Override
    public void beforeEnter(Join<T> join) {
    }

    @Override
    public void enter(Join<T> join) {
        if (join.getChildCount() == 0) {
            join.setFailed(6);
        }
    }

    @Override
    public void onChildCompleted(Join<T> join, Task<T> child) {
        Task mainTask = join.getFirstChild();
        if (child == mainTask) {
            join.setCompleted(child.getStatus(), true);
        }
    }

    @Override
    public void onEvent(Join<T> join, Object event) {
        Task mainTask = join.getFirstChild();
        ParallelChildHelper childHelper = ParallelBranch.getChildHelper(mainTask);
        Task inlinedChild = childHelper.getInlinedChild();
        if (inlinedChild != null) {
            inlinedChild.onEvent(event);
        } else {
            mainTask.onEvent(event);
        }
    }
}

