/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch.join;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.Join;
import cn.wjybxx.btree.branch.JoinPolicy;

public class JoinSelectorN<T>
implements JoinPolicy<T> {
    private int required = 1;
    private boolean failFast;
    private int sequence;

    public JoinSelectorN() {
    }

    public JoinSelectorN(int required) {
        this.required = required;
    }

    @Override
    public void resetForRestart() {
    }

    @Override
    public void beforeEnter(Join<T> join) {
        this.sequence = Math.clamp((long)this.sequence, 0, this.required);
    }

    @Override
    public void enter(Join<T> join) {
        if (this.required <= 0) {
            join.setSuccess();
        } else if (join.getChildCount() == 0) {
            join.setFailed(6);
        } else if (this.checkFailFast(join)) {
            join.setFailed(7);
        }
    }

    @Override
    public void onChildCompleted(Join<T> join, Task<T> child) {
        if (join.getSucceededCount() >= this.required && this.checkSequence(join)) {
            join.setSuccess();
        } else if (join.isAllChildCompleted() || this.checkFailFast(join)) {
            join.setFailed(4);
        }
    }

    private boolean checkSequence(Join<T> join) {
        if (this.sequence == 0) {
            return true;
        }
        for (int idx = this.sequence - 1; idx >= 0; --idx) {
            if (join.getChild(idx).isSucceeded()) continue;
            return false;
        }
        return true;
    }

    private boolean checkFailFast(Join<T> join) {
        if (!this.failFast) {
            return false;
        }
        if (join.getChildCount() - join.getCompletedCount() < this.required - join.getSucceededCount()) {
            return true;
        }
        for (int idx = 0; idx < this.sequence; ++idx) {
            if (!join.getChild(idx).isFailed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onEvent(Join<T> join, Object event) {
    }

    public int getRequired() {
        return this.required;
    }

    public void setRequired(int required) {
        this.required = required;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }
}

