/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;

public abstract class LoopDecorator<T>
extends Decorator<T> {
    protected int maxLoop = -1;
    protected transient int curLoop = 0;

    public LoopDecorator() {
    }

    public LoopDecorator(Task<T> child) {
        super(child);
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        this.curLoop = 0;
    }

    @Override
    protected void execute() {
        Task inlinedChild = this.inlineHelper.getInlinedChild();
        if (inlinedChild != null) {
            inlinedChild.template_executeInlined(this.inlineHelper, this.child);
        } else if (this.child.isRunning()) {
            this.child.template_execute(true);
        } else {
            ++this.curLoop;
            this.template_startChild(this.child, true);
        }
    }

    protected boolean hasNextLoop() {
        return this.maxLoop <= 0 || this.curLoop < this.maxLoop;
    }

    public int getMaxLoop() {
        return this.maxLoop;
    }

    public void setMaxLoop(int maxLoop) {
        this.maxLoop = maxLoop;
    }
}

