/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.fsm.ChangeStateArgs;
import cn.wjybxx.btree.fsm.StateMachineTask;
import javax.annotation.Nullable;

@FunctionalInterface
public interface StateMachineHandler<T> {
    default public void resetForRestart(StateMachineTask<T> stateMachineTask) {
    }

    default public void beforeEnter(StateMachineTask<T> stateMachineTask) {
    }

    default public boolean isReady(StateMachineTask<T> stateMachineTask, @Nullable Task<T> curState, Task<T> nextState) {
        if (curState == null || curState.isCompleted()) {
            return true;
        }
        ChangeStateArgs changeStateArgs = (ChangeStateArgs)nextState.getControlData();
        return changeStateArgs.delayMode == 0;
    }

    public void beforeChangeState(StateMachineTask<T> var1, Task<T> var2, Task<T> var3);

    default public boolean onNextStateAbsent(StateMachineTask<T> stateMachineTask, Task<T> preState) {
        stateMachineTask.setCompleted(preState.getStatus(), true);
        return true;
    }
}

