/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.apt;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Generated;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class AptUtils {
    public static final SourceVersion SOURCE_VERSION = SourceVersion.latestSupported();
    public static final Modifier[] PUBLIC_STATIC = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
    public static final Modifier[] PUBLIC_STATIC_FINAL = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
    public static final Modifier[] PRIVATE_STATIC_FINAL = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL};
    public static final AnnotationSpec SUPPRESS_UNCHECKED_RAWTYPES = AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"unchecked\", \"rawtypes\", \"unused\"}", new Object[0]).build();
    public static final AnnotationSpec SUPPRESS_UNCHECKED = AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"unchecked\", \"unused\"}", new Object[0]).build();
    public static final AnnotationSpec ANNOTATION_OVERRIDE = AnnotationSpec.builder(Override.class).build();
    public static final AnnotationSpec ANNOTATION_NONNULL = AnnotationSpec.builder(Nonnull.class).build();
    public static final ClassName CLSNAME_SOURCE_REF = ClassName.get((String)"cn.wjybxx.base.annotation", (String)"SourceFileRef", (String[])new String[0]);
    public static final ClassName CLSNAME_STRING = ClassName.get(String.class);
    public static final TypeName CLSNAME_BYTES = ArrayTypeName.of((TypeName)TypeName.BYTE);
    public static final ClassName CLSNAME_LIST = ClassName.get(List.class);
    public static final ClassName CLSNAME_ARRAY_LIST = ClassName.get(ArrayList.class);
    public static final ClassName CLSNAME_SET = ClassName.get(Set.class);
    public static final ClassName CLSNAME_HASH_SET = ClassName.get(HashSet.class);
    public static final ClassName CLSNAME_LINKED_SET = ClassName.get(LinkedHashSet.class);
    public static final ClassName CLSNAME_MAP = ClassName.get(Map.class);
    public static final ClassName CLSNAME_HASH_MAP = ClassName.get(HashMap.class);
    public static final ClassName CLSNAME_LINKED_MAP = ClassName.get(LinkedHashMap.class);
    public static final ClassName CLSNAME_SUPPLIER = ClassName.get(Supplier.class);
    public static final ClassName CLSNAME_ARRAYS = ClassName.get(Arrays.class);
    public static final ClassName CLSNAME_OBJECTS = ClassName.get(Objects.class);
    public static final ClassName CLSNAME_FUTURE = ClassName.get(CompletableFuture.class);
    public static final ClassName CLSNAME_STAGE = ClassName.get(CompletionStage.class);
    public static final Map<String, TypeName> primitiveTypeNameMap;
    public static final Map<String, TypeName> boxedTypeNameMap;

    private AptUtils() {
    }

    public static AnnotationSpec newProcessorInfoAnnotation(Class<?> processorType) {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{processorType.getCanonicalName()}).build();
    }

    public static AnnotationSpec newSourceFileRefAnnotation(TypeName sourceFileTypeName) {
        return AnnotationSpec.builder((ClassName)CLSNAME_SOURCE_REF).addMember("value", "$T.class", new Object[]{sourceFileTypeName}).build();
    }

    public static Set<TypeElement> selectSourceFile(RoundEnvironment env, Elements elementUtils, TypeElement annoType) {
        return env.getElementsAnnotatedWith(annoType).stream().filter(e -> e.getKind().isClass() || e.getKind().isInterface()).map(e -> (TypeElement)e).filter(e -> AptUtils.isSourceFile(elementUtils, e)).collect(Collectors.toSet());
    }

    public static Set<TypeElement> selectSourceFileAny(RoundEnvironment env, Elements elementUtils, TypeElement ... annoType) {
        return env.getElementsAnnotatedWithAny(annoType).stream().filter(e -> e.getKind().isClass() || e.getKind().isInterface()).map(e -> (TypeElement)e).filter(e -> AptUtils.isSourceFile(elementUtils, e)).collect(Collectors.toSet());
    }

    public static Set<TypeElement> selectSourceFile(Set<TypeElement> typeElementSet, Elements elementUtils) {
        return typeElementSet.stream().filter(e -> AptUtils.isSourceFile(elementUtils, e)).collect(Collectors.toSet());
    }

    private static boolean isSourceFile(Elements elementUtils, TypeElement typeElement) {
        String binaryName = elementUtils.getBinaryName(typeElement).toString();
        try {
            Class.forName(binaryName, false, null);
            return false;
        }
        catch (Exception ignore) {
            return true;
        }
    }

    public static ClassName classNameOfCanonicalName(String cname) {
        int index = cname.lastIndexOf(46);
        return ClassName.get((String)cname.substring(0, index), (String)cname.substring(index + 1), (String[])new String[0]);
    }

    public static boolean isBoxedType(TypeName typeName) {
        for (TypeName value : boxedTypeNameMap.values()) {
            if (value != typeName) continue;
            return true;
        }
        return false;
    }

    public static MethodSpec.Builder copyMethod(@Nonnull ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName);
        AptUtils.copyModifiers(builder, method);
        AptUtils.copyTypeVariables(builder, method);
        AptUtils.copyReturnType(builder, method);
        AptUtils.copyParameters(builder, method);
        AptUtils.copyExceptionsTable(builder, method);
        builder.varargs(method.isVarArgs());
        return builder;
    }

    public static void copyModifiers(MethodSpec.Builder builder, @Nonnull ExecutableElement method) {
        builder.addModifiers(method.getModifiers());
    }

    public static void copyTypeVariables(MethodSpec.Builder builder, ExecutableElement method) {
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            TypeVariable var = (TypeVariable)typeParameterElement.asType();
            builder.addTypeVariable(TypeVariableName.get((TypeVariable)var));
        }
    }

    public static void copyReturnType(MethodSpec.Builder builder, @Nonnull ExecutableElement method) {
        builder.returns(TypeName.get((TypeMirror)method.getReturnType()));
    }

    public static void copyParameters(MethodSpec.Builder builder, ExecutableElement method) {
        AptUtils.copyParameters(builder, method.getParameters());
    }

    public static void copyParameters(MethodSpec.Builder builder, List<? extends VariableElement> parameters) {
        for (VariableElement variableElement : parameters) {
            builder.addParameter(ParameterSpec.get((VariableElement)variableElement));
        }
    }

    public static void copyExceptionsTable(MethodSpec.Builder builder, ExecutableElement method) {
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            builder.addException(TypeName.get((TypeMirror)typeMirror));
        }
    }

    public static ExecutableElement findMethodByName(TypeElement typeElement, String methodName) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getSimpleName().toString().equals(methodName)).findFirst().orElse(null);
    }

    public static VariableElement findFieldByName(TypeElement typeElement, String field) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD && e.getSimpleName().toString().equals(field)).findFirst().orElse(null);
    }

    public static List<TypeElement> flatInherit(TypeElement typeElement) {
        assert (typeElement.getKind() == ElementKind.CLASS);
        ArrayList<TypeElement> result = new ArrayList<TypeElement>(4);
        result.add(typeElement);
        TypeMirror typeMirror = typeElement.getSuperclass();
        while (typeMirror.getKind() != TypeKind.NONE) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement parentTypeElement = (TypeElement)declaredType.asElement();
            result.add(parentTypeElement);
            typeMirror = parentTypeElement.getSuperclass();
        }
        return result;
    }

    public static List<TypeElement> flatInheritAndReverse(TypeElement typeElement) {
        List<TypeElement> result = AptUtils.flatInherit(typeElement);
        Collections.reverse(result);
        return result;
    }

    public static List<TypeMirror> findAllInterfaces(Types typeUtil, Elements elementUtil, TypeElement typeElement) {
        TypeMirror objectTypeMirror = AptUtils.getTypeMirrorOfClass(elementUtil, Object.class);
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(typeElement.getInterfaces());
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            AptUtils.recursiveFindInterfaces(typeUtil, objectTypeMirror, result, typeMirror);
        }
        return result;
    }

    private static void recursiveFindInterfaces(Types typeUtil, TypeMirror objectMirror, List<TypeMirror> typeMirrors, TypeMirror current) {
        for (TypeMirror typeMirror : typeUtil.directSupertypes(current)) {
            if (AptUtils.isSameTypeIgnoreTypeParameter(typeUtil, objectMirror, typeMirror) || AptUtils.containsTypeMirror(typeUtil, typeMirrors, typeMirror)) continue;
            typeMirrors.add(typeMirror);
            AptUtils.recursiveFindInterfaces(typeUtil, objectMirror, typeMirrors, typeMirror);
        }
    }

    private static boolean containsTypeMirror(Types typeUtil, List<TypeMirror> typeMirrors, TypeMirror typeMirror) {
        for (TypeMirror exist : typeMirrors) {
            if (!AptUtils.isSameTypeIgnoreTypeParameter(typeUtil, typeMirror, exist)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(Types typeUtils, Element element, TypeMirror targetAnnotationMirror) {
        return AptUtils.findAnnotation(typeUtils, element, targetAnnotationMirror) != null;
    }

    public static AnnotationMirror findAnnotation(Types typeUtils, Element element, TypeMirror targetAnnotationMirror) {
        return element.getAnnotationMirrors().stream().filter(annotationMirror -> typeUtils.isSameType(annotationMirror.getAnnotationType(), targetAnnotationMirror)).findFirst().orElse(null);
    }

    public static AnnotationMirror findAnnotationWithInherit(Types typeUtils, Elements elementUtils, Element element, TypeMirror targetAnnotationMirror) {
        return elementUtils.getAllAnnotationMirrors(element).stream().filter(annotationMirror -> typeUtils.isSameType(annotationMirror.getAnnotationType(), targetAnnotationMirror)).findFirst().orElse(null);
    }

    @Nullable
    public static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String propertyName) {
        return annotationMirror.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals(propertyName)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    @Nonnull
    public static AnnotationValue getAnnotationValueWithDefaults(Elements elementUtils, AnnotationMirror annotationMirror, String propertyName) {
        return elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals(propertyName)).map(Map.Entry::getValue).findFirst().orElseThrow();
    }

    @Nullable
    public static <T> T getAnnotationValueValue(AnnotationMirror annotationMirror, String propertyName) {
        return AptUtils.getAnnotationValueValue(annotationMirror, propertyName, null);
    }

    public static <T> T getAnnotationValueValue(AnnotationMirror annotationMirror, String propertyName, T def) {
        AnnotationValue annotationValue = AptUtils.getAnnotationValue(annotationMirror, propertyName);
        return (T)(annotationValue == null ? def : annotationValue.getValue());
    }

    @Nonnull
    public static <T> T getAnnotationValueValueWithDefaults(Elements elementUtils, AnnotationMirror annotationMirror, String propertyName) {
        return (T)AptUtils.getAnnotationValueWithDefaults(elementUtils, annotationMirror, propertyName).getValue();
    }

    public static Map<String, AnnotationValue> getAnnotationValuesMap(AnnotationMirror annotationMirror) {
        LinkedHashMap<String, AnnotationValue> r = new LinkedHashMap<String, AnnotationValue>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            r.put(name, value);
        }
        return r;
    }

    public static TypeMirror getAnnotationValueTypeMirror(AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<TypeMirror, Object>(){

            @Override
            public TypeMirror visitType(TypeMirror t, Object o) {
                return t;
            }
        }, null);
    }

    public static boolean isSubTypeIgnoreTypeParameter(Types typeUtil, TypeMirror first, TypeMirror second) {
        return typeUtil.isSubtype(typeUtil.erasure(first), typeUtil.erasure(second));
    }

    public static boolean isSameTypeIgnoreTypeParameter(Types typeUtil, TypeMirror first, TypeMirror second) {
        return typeUtil.isSameType(typeUtil.erasure(first), typeUtil.erasure(second));
    }

    @Nullable
    public static DeclaredType findDeclaredType(TypeMirror typeMirror) {
        return typeMirror.accept(new SimpleTypeVisitor8<DeclaredType, Object>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Object o) {
                return t;
            }

            @Override
            protected DeclaredType defaultAction(TypeMirror e, Object o) {
                return null;
            }
        }, null);
    }

    public static TypeElement getTypeElementOfClass(Elements elementUtils, Class<?> clazz) {
        return elementUtils.getTypeElement(clazz.getCanonicalName());
    }

    public static TypeMirror getTypeMirrorOfClass(Elements elementUtils, Class<?> clazz) {
        return elementUtils.getTypeElement(clazz.getCanonicalName()).asType();
    }

    public static boolean isPrimitiveBoolean(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.BOOLEAN;
    }

    public static boolean isArrayType(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.ARRAY;
    }

    public static TypeMirror getComponentType(TypeMirror typeMirror) {
        assert (AptUtils.isArrayType(typeMirror));
        ArrayType arrayType = (ArrayType)typeMirror;
        return arrayType.getComponentType();
    }

    public static boolean isByteArray(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return arrayType.getComponentType().getKind() == TypeKind.BYTE;
        }
        return false;
    }

    @Nullable
    public static TypeMirror findFirstTypeParameter(TypeMirror typeMirror) {
        return typeMirror.accept(new SimpleTypeVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType t, Void aVoid) {
                if (t.getTypeArguments().size() == 0) {
                    return null;
                }
                return t.getTypeArguments().get(0);
            }

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void aVoid) {
                return null;
            }
        }, null);
    }

    public static DeclaredType upwardToSuperTypeMirror(Types typeUtils, TypeMirror self, TypeMirror target) {
        if (AptUtils.isSameTypeIgnoreTypeParameter(typeUtils, self, target)) {
            return (DeclaredType)self;
        }
        List<? extends TypeMirror> directSupertypes = typeUtils.directSupertypes(self);
        for (TypeMirror typeMirror : directSupertypes) {
            if (AptUtils.isSameTypeIgnoreTypeParameter(typeUtils, typeMirror, target)) {
                return (DeclaredType)typeMirror;
            }
            if (!AptUtils.isSubTypeIgnoreTypeParameter(typeUtils, typeMirror, target)) continue;
            return AptUtils.upwardToSuperTypeMirror(typeUtils, typeMirror, target);
        }
        throw new IllegalArgumentException(String.format("self: %s, target: %s", self, target));
    }

    public static String getProxyClassName(Elements elementUtils, TypeElement typeElement, String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        if (typeElement.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return typeElement.getSimpleName().toString() + suffix;
        }
        String packageName = elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        String fullName = typeElement.getQualifiedName().toString();
        String uniqueName = fullName.substring(packageName.length() + 1).replace(".", "_");
        return uniqueName + suffix;
    }

    public static void writeToFile(TypeElement sourceElement, TypeSpec.Builder typeBuilder, Elements elementUtils, Messager messager, Filer filer) {
        AptUtils.writeToFile((Element)sourceElement, typeBuilder, AptUtils.getPackageName(sourceElement, elementUtils), messager, filer);
    }

    public static void writeToFile(Element sourceElement, TypeSpec.Builder typeBuilder, String outPackage, Messager messager, Filer filer) {
        TypeSpec typeSpec = typeBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)outPackage, (TypeSpec)typeSpec).skipJavaLangImports(true).indent("    ").build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            messager.printMessage(Diagnostic.Kind.ERROR, AptUtils.getStackTrace(e), sourceElement);
        }
    }

    public static String getPackageName(TypeElement typeElement, Elements elementUtils) {
        return elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static boolean isEmpty(String v) {
        return v == null || v.isEmpty();
    }

    public static boolean isBlank(String v) {
        return v == null || v.isBlank();
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> c) {
        return c == null || c.isEmpty();
    }

    static {
        LinkedHashMap<String, TypeName> tempMap = new LinkedHashMap<String, TypeName>(16);
        tempMap.put("int", TypeName.INT);
        tempMap.put("long", TypeName.LONG);
        tempMap.put("float", TypeName.FLOAT);
        tempMap.put("double", TypeName.DOUBLE);
        tempMap.put("boolean", TypeName.BOOLEAN);
        tempMap.put("short", TypeName.SHORT);
        tempMap.put("byte", TypeName.BYTE);
        tempMap.put("char", TypeName.CHAR);
        primitiveTypeNameMap = Collections.unmodifiableMap(tempMap);
        tempMap = new LinkedHashMap(16);
        tempMap.put("Integer", TypeName.INT.box());
        tempMap.put("Long", TypeName.LONG.box());
        tempMap.put("Float", TypeName.FLOAT.box());
        tempMap.put("Double", TypeName.DOUBLE.box());
        tempMap.put("Boolean", TypeName.BOOLEAN.box());
        tempMap.put("Short", TypeName.SHORT.box());
        tempMap.put("Byte", TypeName.BYTE.box());
        tempMap.put("Character", TypeName.CHAR.box());
        boxedTypeNameMap = Collections.unmodifiableMap(tempMap);
    }
}

