/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.apt;

import cn.wjybxx.apt.AptUtils;
import com.squareup.javapoet.AnnotationSpec;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public abstract class MyAbstractProcessor
extends AbstractProcessor {
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Messager messager;
    protected Filer filer;
    protected AnnotationSpec processorInfoAnnotation;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.processorInfoAnnotation = AptUtils.newProcessorInfoAnnotation(this.getClass());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return AptUtils.SOURCE_VERSION;
    }

    @Override
    public abstract Set<String> getSupportedAnnotationTypes();

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.ensureInited();
        }
        catch (Throwable e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, AptUtils.getStackTrace(e));
            return false;
        }
        try {
            return this.doProcess(annotations, roundEnv);
        }
        catch (Throwable e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, AptUtils.getStackTrace(e));
            return false;
        }
    }

    protected abstract void ensureInited();

    protected abstract boolean doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);
}

