/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.apt;

import cn.wjybxx.apt.AptUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class BeanUtils {
    public static boolean containsNoArgsConstructor(TypeElement typeElement) {
        return BeanUtils.getNoArgsConstructor(typeElement) != null;
    }

    public static boolean containsOneArgsConstructor(Types typeUtils, TypeElement typeElement, TypeMirror argType) {
        return BeanUtils.getOneArgsConstructor(typeUtils, typeElement, argType) != null;
    }

    @Nullable
    public static ExecutableElement getNoArgsConstructor(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(e -> (ExecutableElement)e).filter(e -> e.getParameters().isEmpty()).findFirst().orElse(null);
    }

    @Nullable
    public static ExecutableElement getOneArgsConstructor(Types typeUtils, TypeElement typeElement, TypeMirror argType) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(e -> (ExecutableElement)e).filter(e -> e.getParameters().size() == 1).filter(e -> AptUtils.isSubTypeIgnoreTypeParameter(typeUtils, e.getParameters().get(0).asType(), argType)).findFirst().orElse(null);
    }

    public static List<Element> getAllFieldsAndMethodsWithInherit(TypeElement typeElement) {
        List<TypeElement> flatInherit = AptUtils.flatInheritAndReverse(typeElement);
        return flatInherit.stream().flatMap(e -> e.getEnclosedElements().stream()).filter(e -> e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.FIELD).collect(Collectors.toList());
    }

    public static List<Element> getAllFieldsWithInherit(TypeElement typeElement) {
        List<TypeElement> flatInherit = AptUtils.flatInheritAndReverse(typeElement);
        return flatInherit.stream().flatMap(e -> e.getEnclosedElements().stream()).filter(e -> e.getKind() == ElementKind.FIELD).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getAllMethodsWithInherit(TypeElement typeElement) {
        List<TypeElement> flatInherit = AptUtils.flatInheritAndReverse(typeElement);
        return flatInherit.stream().flatMap(e -> e.getEnclosedElements().stream()).filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).collect(Collectors.toList());
    }

    public static boolean containsPublicSetter(Types typeUtils, VariableElement variableElement, List<? extends Element> allFieldsAndMethodWithInherit) {
        return BeanUtils.findPublicSetter(typeUtils, variableElement, allFieldsAndMethodWithInherit) != null;
    }

    public static boolean containsPublicGetter(Types typeUtils, VariableElement variableElement, List<? extends Element> allFieldsAndMethodWithInherit) {
        return BeanUtils.findPublicGetter(typeUtils, variableElement, allFieldsAndMethodWithInherit) != null;
    }

    public static ExecutableElement findPublicSetter(Types typeUtils, VariableElement variableElement, List<? extends Element> allFieldsAndMethodWithInherit) {
        String fieldName = variableElement.getSimpleName().toString();
        String setterMethodName = BeanUtils.setterMethodName(fieldName, AptUtils.isPrimitiveBoolean(variableElement.asType()));
        String setterMethodName2 = "set" + BeanUtils.firstCharToUpperCase(fieldName);
        return allFieldsAndMethodWithInherit.stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).filter(e -> {
            if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return false;
            }
            if (e.getParameters().size() != 1) {
                return false;
            }
            String mName = e.getSimpleName().toString();
            return mName.equals(setterMethodName) || mName.equals(setterMethodName2);
        }).findFirst().orElse(null);
    }

    public static ExecutableElement findPublicGetter(Types typeUtils, VariableElement variableElement, List<? extends Element> allFieldsAndMethodWithInherit) {
        String fieldName = variableElement.getSimpleName().toString();
        String getterMethodName = BeanUtils.getterMethodName(fieldName, AptUtils.isPrimitiveBoolean(variableElement.asType()));
        String getterMethodName2 = "get" + BeanUtils.firstCharToUpperCase(fieldName);
        return allFieldsAndMethodWithInherit.stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).filter(e -> {
            if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return false;
            }
            if (e.getParameters().size() != 0) {
                return false;
            }
            String mName = e.getSimpleName().toString();
            return mName.equals(getterMethodName) || mName.equals(getterMethodName2);
        }).findFirst().orElse(null);
    }

    public static String getterMethodName(String filedName, boolean isPrimitiveBoolean) {
        if (BeanUtils.isFirstOrSecondCharUpperCase(filedName)) {
            if (isPrimitiveBoolean) {
                return "is" + filedName;
            }
            return "get" + filedName;
        }
        if (isPrimitiveBoolean) {
            if (filedName.length() > 2 && filedName.startsWith("is")) {
                return filedName;
            }
            return "is" + BeanUtils.firstCharToUpperCase(filedName);
        }
        return "get" + BeanUtils.firstCharToUpperCase(filedName);
    }

    public static String setterMethodName(String filedName, boolean isPrimitiveBoolean) {
        if (BeanUtils.isFirstOrSecondCharUpperCase(filedName)) {
            return "set" + filedName;
        }
        if (isPrimitiveBoolean) {
            if (filedName.length() > 2 && filedName.startsWith("is")) {
                return "set" + BeanUtils.firstCharToUpperCase(filedName.substring(2));
            }
            return "set" + BeanUtils.firstCharToUpperCase(filedName);
        }
        return "set" + BeanUtils.firstCharToUpperCase(filedName);
    }

    public static String firstCharToUpperCase(@Nonnull String str) {
        if (str.isEmpty()) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(0, Character.toUpperCase(firstChar));
            return sb.toString();
        }
        return str;
    }

    public static String firstCharToLowerCase(@Nonnull String str) {
        if (str.isEmpty()) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(0, Character.toLowerCase(firstChar));
            return sb.toString();
        }
        return str;
    }

    private static boolean isFirstOrSecondCharUpperCase(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (Character.isUpperCase(name.charAt(0)) || name.charAt(0) == '_') {
            return true;
        }
        return name.length() > 1 && Character.isUpperCase(name.charAt(1));
    }
}

