/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import javax.annotation.Nonnull;

public interface Constant
extends Comparable<Constant> {
    public int id();

    @Nonnull
    public String name();

    @Nonnull
    public String poolId();

    public static String checkName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is empty ");
        }
        return name;
    }

    public static abstract class Builder<T extends Constant> {
        private String poolId;
        private Integer id;
        private final String name;
        private int cacheIndex = -1;
        private boolean requireCacheIndex;

        public Builder(String name) {
            this.name = Constant.checkName(name);
        }

        public void setId(String poolId, int id, int cacheIndex) {
            if (this.id != null) {
                throw new IllegalStateException("id cannot be initialized repeatedly");
            }
            this.poolId = poolId;
            this.id = id;
            this.cacheIndex = cacheIndex;
        }

        public int getIdOrThrow() {
            if (this.id == null) {
                throw new IllegalStateException("id has not been initialized");
            }
            return this.id;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPoolId() {
            return this.poolId;
        }

        public int getCacheIndex() {
            return this.cacheIndex;
        }

        public boolean isRequireCacheIndex() {
            return this.requireCacheIndex;
        }

        public Builder<T> setRequireCacheIndex(boolean requireCacheIndex) {
            this.requireCacheIndex = requireCacheIndex;
            return this;
        }

        public abstract T build();
    }
}

