/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.collection.IndexedElementHelper;
import cn.wjybxx.base.collection.IndexedPriorityQueue;
import cn.wjybxx.base.reflect.TypeParameterFinder;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BetterIndexedPriorityQueue<T>
extends AbstractQueue<T>
implements IndexedPriorityQueue<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int DEFAULT_CAPACITY = 16;
    private final Comparator<? super T> comparator;
    private final IndexedElementHelper<? super T> helper;
    private final Class<?> componentType;
    private T[] queue;
    private int size;

    public BetterIndexedPriorityQueue(Comparator<? super T> comparator, IndexedElementHelper<? super T> helper) {
        this(comparator, helper, 16);
    }

    public BetterIndexedPriorityQueue(Comparator<? super T> comparator, IndexedElementHelper<? super T> helper, int initialSize) {
        this.comparator = Objects.requireNonNull(comparator, "comparator");
        this.helper = Objects.requireNonNull(helper, "helper");
        this.componentType = TypeParameterFinder.findTypeParameter(helper, IndexedElementHelper.class, "E");
        this.queue = initialSize != 0 ? new Object[initialSize] : EMPTY_ARRAY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!this.componentType.isInstance(o)) {
            return false;
        }
        Object node = o;
        return this.contains(node, this.helper.collectionIndex(this, node));
    }

    @Override
    public boolean containsTyped(T node) {
        if (node == null) {
            return false;
        }
        return this.contains(node, this.helper.collectionIndex(this, node));
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            T node = this.queue[i];
            if (node == null) continue;
            this.helper.collectionIndex(this, node, -1);
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public void clearIgnoringIndexes() {
        Arrays.fill(this.queue, null);
        this.size = 0;
    }

    @Override
    public boolean offer(T e) {
        Objects.requireNonNull(e);
        if (this.helper.collectionIndex(this, e) != -1) {
            throw new IllegalArgumentException("e.queueIndex(): %d (expected: %d) + e: %s".formatted(this.helper.collectionIndex(this, e), -1, e));
        }
        if (this.size >= this.queue.length) {
            int grow = this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1;
            this.queue = Arrays.copyOf(this.queue, this.queue.length + grow);
        }
        this.bubbleUp(this.size++, e);
        return true;
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        T node = this.queue[0];
        this.removeAt(0, node);
        return node;
    }

    @Override
    public T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    @Override
    public boolean remove(Object o) {
        if (!this.componentType.isInstance(o)) {
            return false;
        }
        Object node = o;
        return this.removeTyped((T)node);
    }

    @Override
    public boolean removeTyped(T node) {
        if (node == null) {
            return false;
        }
        int idx = this.helper.collectionIndex(this, node);
        if (!this.contains(node, idx)) {
            return false;
        }
        this.removeAt(idx, node);
        return true;
    }

    @Override
    public void priorityChanged(T node) {
        Objects.requireNonNull(node);
        int idx = this.helper.collectionIndex(this, node);
        if (!this.contains(node, idx)) {
            return;
        }
        if (idx == 0) {
            this.bubbleDown(idx, node);
        } else {
            int iParent = idx - 1 >>> 1;
            T parent = this.queue[iParent];
            if (this.comparator.compare(node, parent) < 0) {
                this.bubbleUp(idx, node);
            } else {
                this.bubbleDown(idx, node);
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    private boolean contains(T node, int idx) {
        return idx >= 0 && idx < this.size && node == this.queue[idx];
    }

    private void removeAt(int idx, T node) {
        this.helper.collectionIndex(this, node, -1);
        int newSize = --this.size;
        if (newSize == idx) {
            this.queue[idx] = null;
            return;
        }
        T moved = this.queue[idx] = this.queue[newSize];
        this.queue[newSize] = null;
        if (idx == 0 || this.comparator.compare(node, moved) < 0) {
            this.bubbleDown(idx, moved);
        } else {
            this.bubbleUp(idx, moved);
        }
    }

    private void bubbleDown(int k, T node) {
        T[] queue = this.queue;
        int half = this.size >>> 1;
        while (k < half) {
            int iChild = (k << 1) + 1;
            T child = queue[iChild];
            int iRightChild = iChild + 1;
            if (iRightChild < this.size && this.comparator.compare(child, queue[iRightChild]) > 0) {
                iChild = iRightChild;
                child = queue[iChild];
            }
            if (this.comparator.compare(node, child) <= 0) break;
            queue[k] = child;
            this.helper.collectionIndex(this, child, k);
            k = iChild;
        }
        queue[k] = node;
        this.helper.collectionIndex(this, node, k);
    }

    private void bubbleUp(int k, T node) {
        int iParent;
        T parent;
        T[] queue = this.queue;
        while (k > 0 && this.comparator.compare(node, parent = queue[iParent = k - 1 >>> 1]) < 0) {
            queue[k] = parent;
            this.helper.collectionIndex(this, parent, k);
            k = iParent;
        }
        queue[k] = node;
        this.helper.collectionIndex(this, node, k);
    }

    private final class PriorityQueueIterator
    implements Iterator<T> {
        private int index;

        private PriorityQueueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < BetterIndexedPriorityQueue.this.size;
        }

        @Override
        public T next() {
            if (this.index >= BetterIndexedPriorityQueue.this.size) {
                throw new NoSuchElementException();
            }
            return BetterIndexedPriorityQueue.this.queue[this.index++];
        }
    }
}

