/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.collection.IndexedElement;
import cn.wjybxx.base.collection.IndexedPriorityQueue;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DefaultIndexedPriorityQueue<T extends IndexedElement>
extends AbstractQueue<T>
implements IndexedPriorityQueue<T> {
    private static final IndexedElement[] EMPTY_ARRAY = new IndexedElement[0];
    private static final int DEFAULT_CAPACITY = 16;
    private final Comparator<? super T> comparator;
    private T[] queue;
    private int size;

    public DefaultIndexedPriorityQueue(Comparator<? super T> comparator) {
        this(comparator, 16);
    }

    public DefaultIndexedPriorityQueue(Comparator<? super T> comparator, int initialSize) {
        this.comparator = Objects.requireNonNull(comparator, "comparator");
        this.queue = initialSize != 0 ? new IndexedElement[initialSize] : EMPTY_ARRAY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof IndexedElement)) {
            return false;
        }
        IndexedElement node = (IndexedElement)o;
        return this.contains(node, node.collectionIndex(this));
    }

    @Override
    public boolean containsTyped(T node) {
        if (node == null) {
            return false;
        }
        return this.contains((IndexedElement)node, node.collectionIndex(this));
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            T node = this.queue[i];
            if (node == null) continue;
            node.collectionIndex(this, -1);
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public void clearIgnoringIndexes() {
        Arrays.fill(this.queue, null);
        this.size = 0;
    }

    @Override
    public boolean offer(T e) {
        if (e.collectionIndex(this) != -1) {
            throw new IllegalArgumentException("e.queueIndex(): %d (expected: %d) + e: %s".formatted(e.collectionIndex(this), -1, e));
        }
        if (this.size >= this.queue.length) {
            int grow = this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1;
            this.queue = (IndexedElement[])Arrays.copyOf(this.queue, this.queue.length + grow);
        }
        this.bubbleUp(this.size++, e);
        return true;
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        T node = this.queue[0];
        this.removeAt(0, node);
        return node;
    }

    @Override
    public T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IndexedElement)) {
            return false;
        }
        IndexedElement node = (IndexedElement)o;
        return this.removeTyped((T)node);
    }

    @Override
    public boolean removeTyped(T node) {
        if (node == null) {
            return false;
        }
        int idx = node.collectionIndex(this);
        if (!this.contains((IndexedElement)node, idx)) {
            return false;
        }
        this.removeAt(idx, node);
        return true;
    }

    @Override
    public void priorityChanged(T node) {
        int idx = node.collectionIndex(this);
        if (!this.contains((IndexedElement)node, idx)) {
            return;
        }
        if (idx == 0) {
            this.bubbleDown(idx, node);
        } else {
            int iParent = idx - 1 >>> 1;
            T parent = this.queue[iParent];
            if (this.comparator.compare(node, parent) < 0) {
                this.bubbleUp(idx, node);
            } else {
                this.bubbleDown(idx, node);
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    private boolean contains(IndexedElement node, int idx) {
        return idx >= 0 && idx < this.size && node == this.queue[idx];
    }

    private void removeAt(int idx, T node) {
        node.collectionIndex(this, -1);
        int newSize = --this.size;
        if (newSize == idx) {
            this.queue[idx] = null;
            return;
        }
        T moved = this.queue[idx] = this.queue[newSize];
        this.queue[newSize] = null;
        if (idx == 0 || this.comparator.compare(node, moved) < 0) {
            this.bubbleDown(idx, moved);
        } else {
            this.bubbleUp(idx, moved);
        }
    }

    private void bubbleDown(int k, T node) {
        T[] queue = this.queue;
        int half = this.size >>> 1;
        while (k < half) {
            int iChild = (k << 1) + 1;
            T child = queue[iChild];
            int iRightChild = iChild + 1;
            if (iRightChild < this.size && this.comparator.compare(child, queue[iRightChild]) > 0) {
                iChild = iRightChild;
                child = queue[iChild];
            }
            if (this.comparator.compare(node, child) <= 0) break;
            queue[k] = child;
            child.collectionIndex(this, k);
            k = iChild;
        }
        queue[k] = node;
        node.collectionIndex(this, k);
    }

    private void bubbleUp(int k, T node) {
        int iParent;
        T parent;
        T[] queue = this.queue;
        while (k > 0 && this.comparator.compare(node, parent = queue[iParent = k - 1 >>> 1]) < 0) {
            queue[k] = parent;
            parent.collectionIndex(this, k);
            k = iParent;
        }
        queue[k] = node;
        node.collectionIndex(this, k);
    }

    private final class PriorityQueueIterator
    implements Iterator<T> {
        private int index;

        private PriorityQueueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < DefaultIndexedPriorityQueue.this.size;
        }

        @Override
        public T next() {
            if (this.index >= DefaultIndexedPriorityQueue.this.size) {
                throw new NoSuchElementException();
            }
            return DefaultIndexedPriorityQueue.this.queue[this.index++];
        }
    }
}

