/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.MathCommon;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;

public final class MpmcObjectBucket<E> {
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private long p8;
    private final int length;
    private final Object[] buffer;
    private final long[] published;
    private final long[] consumed;
    private long p11;
    private long p12;
    private long p13;
    private long p14;
    private long p15;
    private long p16;
    private long p17;
    private long p18;
    private volatile long producerIndex = -1L;
    private long p21;
    private long p22;
    private long p23;
    private long p24;
    private long p25;
    private long p26;
    private long p27;
    private volatile long consumerIndex = -1L;
    private long p31;
    private long p32;
    private long p33;
    private long p34;
    private long p35;
    private long p36;
    private long p37;
    private static final VarHandle VH_ELEMENTS;
    private static final VarHandle VH_LONG_ARRAY;
    private static final VarHandle VH_PRODUCER;
    private static final VarHandle VH_CONSUMER;

    public MpmcObjectBucket(int length) {
        this.length = length;
        this.buffer = new Object[length];
        this.published = new long[length];
        this.consumed = new long[length];
        Arrays.fill(this.published, -1L);
        Arrays.fill(this.consumed, -1L);
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return MathCommon.clamp(this.lvProducerIndex() - this.lvConsumerIndex(), 0, this.length);
    }

    public boolean offer(E element) {
        long current;
        long next;
        if (this.length == 0) {
            return false;
        }
        Objects.requireNonNull(element);
        do {
            long wrapPoint;
            if ((wrapPoint = (next = (current = this.lvProducerIndex()) + 1L) - (long)this.length) < 0L || this.isConsumed(wrapPoint)) continue;
            if (wrapPoint <= this.lvConsumerIndex()) {
                next = current;
                continue;
            }
            return false;
        } while (next == current || !this.casProducerIndex(current, next));
        int index = this.indexOfSequence(next);
        this.spElement(index, element);
        this.markPublished(next);
        return true;
    }

    public E poll() {
        long current;
        long next;
        if (this.length == 0) {
            return null;
        }
        do {
            if (this.isPublished(next = (current = this.lvConsumerIndex()) + 1L)) continue;
            if (next <= this.lvProducerIndex()) {
                next = current;
                continue;
            }
            return null;
        } while (next == current || !this.casConsumerIndex(current, next));
        int index = this.indexOfSequence(next);
        E element = this.lpElement(index);
        this.spElement(index, null);
        this.markConsumed(next);
        return element;
    }

    private long lvProducerIndex() {
        return this.producerIndex;
    }

    private boolean casProducerIndex(long expect, long newValue) {
        return VH_PRODUCER.compareAndSet(this, expect, newValue);
    }

    private long lvConsumerIndex() {
        return this.consumerIndex;
    }

    private boolean casConsumerIndex(long expect, long newValue) {
        return VH_CONSUMER.compareAndSet(this, expect, newValue);
    }

    private void spElement(int index, E e) {
        VH_ELEMENTS.set(this.buffer, index, e);
    }

    private void soElement(int index, E e) {
        VH_ELEMENTS.setRelease(this.buffer, index, e);
    }

    private E lvElement(int index) {
        return (E)VH_ELEMENTS.getVolatile(this.buffer, index);
    }

    private E lpElement(int index) {
        return (E)VH_ELEMENTS.get(this.buffer, index);
    }

    private void markPublished(long sequence) {
        int index = this.indexOfSequence(sequence);
        VH_LONG_ARRAY.setRelease(this.published, index, sequence);
    }

    private boolean isPublished(long sequence) {
        int index = this.indexOfSequence(sequence);
        long flag = VH_LONG_ARRAY.getVolatile(this.published, index);
        return flag == sequence;
    }

    private void markConsumed(long sequence) {
        int index = this.indexOfSequence(sequence);
        VH_LONG_ARRAY.setRelease(this.consumed, index, sequence);
    }

    private boolean isConsumed(long sequence) {
        int index = this.indexOfSequence(sequence);
        long flag = VH_LONG_ARRAY.getVolatile(this.consumed, index);
        return flag == sequence;
    }

    private int indexOfSequence(long sequence) {
        return (int)(sequence % (long)this.length);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VH_PRODUCER = l.findVarHandle(MpmcObjectBucket.class, "producerIndex", Long.TYPE);
            VH_CONSUMER = l.findVarHandle(MpmcObjectBucket.class, "consumerIndex", Long.TYPE);
            VH_ELEMENTS = MethodHandles.arrayElementVarHandle(Object[].class);
            VH_LONG_ARRAY = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

