/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.function.FunctionUtils;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SingleObjectPool<T>
implements ObjectPool<T> {
    private final Supplier<? extends T> factory;
    private final Consumer<? super T> resetHandler;
    private final Predicate<? super T> filter;
    private T value;

    public SingleObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler) {
        this(factory, resetHandler, null);
    }

    public SingleObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler, Predicate<? super T> filter) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetHandler = ObjectUtils.nullToDef(resetHandler, FunctionUtils.emptyConsumer());
        this.filter = filter;
    }

    @Override
    public T get() {
        return this.acquire();
    }

    @Override
    public T acquire() {
        T result = this.value;
        if (result != null) {
            this.value = null;
        } else {
            result = this.factory.get();
        }
        return result;
    }

    @Override
    public void release(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        assert (obj != this.value);
        this.resetHandler.accept(obj);
        if (this.filter == null || this.filter.test(obj)) {
            this.value = obj;
        }
    }

    @Override
    public void clear() {
        this.value = null;
    }
}

