/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;

public class TypeParameterFinder {
    public static <T> Type getGenericSuperType(Class<T> thisClass, Class<? super T> superClazzOrInterface) {
        assert (superClazzOrInterface.isAssignableFrom(thisClass));
        if (thisClass == superClazzOrInterface) {
            throw new IllegalArgumentException("thisClass == superClazzOrInterface");
        }
        if (superClazzOrInterface.isInterface()) {
            Class<? super T> directChildClass = TypeParameterFinder.findInterfaceDirectChildClass(thisClass, superClazzOrInterface);
            return TypeParameterFinder.getGenericInterface(directChildClass, superClazzOrInterface);
        }
        Class<T> currentClass = thisClass;
        while (currentClass.getSuperclass() != superClazzOrInterface) {
            currentClass = currentClass.getSuperclass();
        }
        return currentClass.getGenericSuperclass();
    }

    public static <T> Class<?> findTypeParameter(T instance, Class<? super T> superClazzOrInterface, String typeParamName) {
        Objects.requireNonNull(instance, "instance");
        Class<?> thisClass = instance.getClass();
        return TypeParameterFinder.findTypeParameterUnsafe(thisClass, superClazzOrInterface, typeParamName);
    }

    public static <T> Class<?> findTypeParameterUnsafe(Class<T> thisClass, Class<? super T> superClazzOrInterface, String typeParamName) {
        Objects.requireNonNull(thisClass, "thisClass");
        Objects.requireNonNull(superClazzOrInterface, "superClazzOrInterface");
        Objects.requireNonNull(typeParamName, "typeParamName");
        if (thisClass == superClazzOrInterface) {
            throw new IllegalArgumentException("typeParam " + typeParamName + " is declared in self class: " + thisClass.getSimpleName() + ", only support find superClassOrInterface typeParam.");
        }
        TypeParameterFinder.ensureTypeParameterExist(superClazzOrInterface, typeParamName);
        if (superClazzOrInterface.isInterface()) {
            return TypeParameterFinder.findInterfaceTypeParameter(thisClass, superClazzOrInterface, typeParamName);
        }
        return TypeParameterFinder.find0(thisClass, superClazzOrInterface, typeParamName);
    }

    private static void ensureTypeParameterExist(Class<?> parametrizedSuperInterface, String typeVarName) {
        if (TypeParameterFinder.indexTypeParam(parametrizedSuperInterface, typeVarName) < 0) {
            throw new IllegalArgumentException("typeVarName " + typeVarName + " is not declared in superClazz/interface " + parametrizedSuperInterface.getSimpleName());
        }
    }

    private static <T> Class<?> findInterfaceTypeParameter(Class<T> thisClass, Class<? super T> parametrizedInterface, String typeParamName) {
        Class<? super T> directChildClass = TypeParameterFinder.findInterfaceDirectChildClass(thisClass, parametrizedInterface);
        return TypeParameterFinder.parseTypeParameter(thisClass, directChildClass, parametrizedInterface, typeParamName);
    }

    private static <T> Class<? super T> findInterfaceDirectChildClass(Class<? super T> currentClazzOrInterface, Class<? super T> parametrizedInterface) {
        Class<?>[] implementationInterfaces;
        if (!parametrizedInterface.isAssignableFrom(currentClazzOrInterface)) {
            throw new IllegalArgumentException("currentClazzOrInterface=" + currentClazzOrInterface.getSimpleName() + " ,parametrizedInterface=" + parametrizedInterface.getSimpleName());
        }
        for (Class<?> clazz : implementationInterfaces = currentClazzOrInterface.getInterfaces()) {
            if (clazz != parametrizedInterface) continue;
            return currentClazzOrInterface;
        }
        Class<? super T> superclass = currentClazzOrInterface.getSuperclass();
        if (null != superclass && parametrizedInterface.isAssignableFrom(superclass)) {
            return TypeParameterFinder.findInterfaceDirectChildClass(superclass, parametrizedInterface);
        }
        assert (parametrizedInterface.isInterface()) : "currentClazzOrInterface " + currentClazzOrInterface.getSimpleName() + " i";
        for (Class<?> oneSuperInterface : implementationInterfaces) {
            if (!parametrizedInterface.isAssignableFrom(oneSuperInterface)) continue;
            Class<?> superInterface = oneSuperInterface;
            return TypeParameterFinder.findInterfaceDirectChildClass(superInterface, parametrizedInterface);
        }
        throw new AssertionError();
    }

    private static <T> Class<?> parseTypeParameter(Class<? extends T> thisClass, Class<? super T> directChildClass, Class<? super T> parametrizedSuperInterface, String typeParamName) {
        Object parameterizedType;
        int typeParamIndex = TypeParameterFinder.indexTypeParam(parametrizedSuperInterface, typeParamName);
        assert (typeParamIndex >= 0);
        Type genericSuperInterface = TypeParameterFinder.getGenericInterface(directChildClass, parametrizedSuperInterface);
        if (!(genericSuperInterface instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] actualTypeParams = ((ParameterizedType)genericSuperInterface).getActualTypeArguments();
        Type actualTypeParam = actualTypeParams[typeParamIndex];
        if (actualTypeParam instanceof ParameterizedType) {
            ParameterizedType parameterizedType2 = (ParameterizedType)actualTypeParam;
            actualTypeParam = parameterizedType2.getRawType();
        }
        if (actualTypeParam instanceof Class) {
            Class clazz = (Class)actualTypeParam;
            return clazz;
        }
        if (actualTypeParam instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)actualTypeParam;
            Type componentType = arrayType.getGenericComponentType();
            if (componentType instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)componentType;
                componentType = parameterizedType.getRawType();
            }
            if (componentType instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
        }
        if (actualTypeParam instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)actualTypeParam;
            parameterizedType = typeVar.getGenericDeclaration();
            if (!(parameterizedType instanceof Class)) {
                return Object.class;
            }
            Class genericDeclarationClass = (Class)parameterizedType;
            if (parametrizedSuperInterface.isAssignableFrom(thisClass)) {
                Class newSuperClazzOrInterface = genericDeclarationClass;
                return TypeParameterFinder.findTypeParameterUnsafe(thisClass, newSuperClazzOrInterface, typeVar.getName());
            }
            return Object.class;
        }
        return TypeParameterFinder.fail(thisClass, typeParamName);
    }

    private static <T> Type getGenericInterface(Class<? super T> directChildClass, Class<? super T> superInterface) {
        Class<?>[] extendsOrImpInterfaces = directChildClass.getInterfaces();
        for (int index = 0; index < extendsOrImpInterfaces.length; ++index) {
            if (extendsOrImpInterfaces[index] != superInterface) continue;
            return directChildClass.getGenericInterfaces()[index];
        }
        throw new AssertionError((Object)"genericSuperInterface");
    }

    private static int indexTypeParam(Class<?> clazz, String typeVarName) {
        TypeVariable<Class<?>>[] typeParams = clazz.getTypeParameters();
        for (int idx = 0; idx < typeParams.length; ++idx) {
            if (!typeVarName.equals(typeParams[idx].getName())) continue;
            return idx;
        }
        return -1;
    }

    private static Class<?> fail(Class<?> type, String typeParamName) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + typeParamName + "': " + String.valueOf(type));
    }

    private static Class<?> find0(Class<?> thisClass, Class<?> parametrizedSuperclass, String typeParamName) {
        Class<?> currentClass = thisClass;
        while (true) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = TypeParameterFinder.indexTypeParam(parametrizedSuperclass, typeParamName);
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + String.valueOf(parametrizedSuperclass));
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)actualTypeParam;
                    actualTypeParam = parameterizedType.getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    Class clazz = (Class)actualTypeParam;
                    return clazz;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)actualTypeParam;
                    Type componentType = arrayType.getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    TypeVariable typeVar = (TypeVariable)actualTypeParam;
                    currentClass = thisClass;
                    if (!(typeVar.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    parametrizedSuperclass = (Class)typeVar.getGenericDeclaration();
                    typeParamName = typeVar.getName();
                    if (parametrizedSuperclass.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                return TypeParameterFinder.fail(thisClass, typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        return TypeParameterFinder.fail(thisClass, typeParamName);
    }
}

