/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.time;

public class Regulator {
    private static final byte ONCE = 0;
    private static final byte FIX_DELAY = 1;
    private static final byte FIX_RATE = 2;
    private final byte type;
    private long firstDelay;
    private long period;
    private long lastUpdateTime;
    private long deltaTime;
    private int count;
    private Object context;

    private Regulator(byte type, long firstDelay, long period, long lastUpdateTime) {
        this.type = type;
        this.firstDelay = firstDelay;
        this.period = period;
        this.lastUpdateTime = lastUpdateTime;
        this.deltaTime = 0L;
        this.count = 0;
    }

    private static long checkFirstDelay(byte type, long firstDelay) {
        if (type == 2 && firstDelay < 0L) {
            throw new IllegalArgumentException("the firstDelay of fixRate must gte 0, delay " + firstDelay);
        }
        return firstDelay;
    }

    private static long checkPeriod(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be positive, period " + period);
        }
        return period;
    }

    public static Regulator newOnce(long firstDelay) {
        return new Regulator(0, firstDelay, 0L, 0L);
    }

    public static Regulator newFixedDelay(long firstDelay, long period) {
        Regulator.checkPeriod(period);
        return new Regulator(1, firstDelay, period, 0L);
    }

    public static Regulator newFixedRate(long firstDelay, long period) {
        Regulator.checkPeriod(period);
        Regulator.checkFirstDelay((byte)2, firstDelay);
        return new Regulator(2, firstDelay, period, 0L);
    }

    public Regulator restart(long curTime) {
        this.lastUpdateTime = curTime;
        this.deltaTime = 0L;
        this.count = 0;
        return this;
    }

    public boolean isReady(long curTime) {
        boolean ready;
        boolean bl = this.count == 0 ? curTime - this.lastUpdateTime >= this.firstDelay : (ready = this.period > 0L && curTime - this.lastUpdateTime >= this.period);
        if (ready) {
            this.internalUpdate(curTime);
            return true;
        }
        return false;
    }

    public long forceReady(long curTime) {
        this.internalUpdate(curTime);
        return this.deltaTime;
    }

    private void internalUpdate(long curTime) {
        if (this.type == 1 || this.type == 0) {
            this.deltaTime = Math.max(0L, curTime - this.lastUpdateTime);
            this.lastUpdateTime = curTime;
        } else if (this.count == 0) {
            this.deltaTime = this.firstDelay;
            this.lastUpdateTime += this.firstDelay;
        } else {
            this.deltaTime = this.period;
            this.lastUpdateTime += this.period;
        }
        ++this.count;
    }

    public long getDelay(long curTime) {
        if (this.count == 0) {
            return Math.max(0L, curTime - this.lastUpdateTime - this.firstDelay);
        }
        return Math.max(0L, curTime - this.lastUpdateTime - this.period);
    }

    public void correctTime(long curTime) {
        this.lastUpdateTime = curTime;
    }

    public boolean isPeriodic() {
        return this.period != 0L;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getDeltaTime() {
        return this.deltaTime;
    }

    public int getCount() {
        return this.count;
    }

    public Object getContext() {
        return this.context;
    }

    public Regulator setContext(Object context) {
        this.context = context;
        return this;
    }

    public long getFirstDelay() {
        return this.firstDelay;
    }

    public void setFirstDelay(long firstDelay) {
        this.firstDelay = Regulator.checkFirstDelay(this.type, firstDelay);
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = Regulator.checkPeriod(period);
    }
}

