/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.Constant;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractConstant
implements Constant {
    private final int id;
    private final String name;
    private final String poolId;

    protected AbstractConstant(Constant.Builder<?> builder) {
        this.id = builder.getIdOrThrow();
        this.name = Objects.requireNonNull(builder.getName());
        this.poolId = Objects.requireNonNull(builder.getPoolId(), "poolId");
    }

    @Override
    public final int id() {
        return this.id;
    }

    @Override
    @Nonnull
    public final String name() {
        return this.name;
    }

    @Override
    @Nonnull
    public final String poolId() {
        return this.poolId;
    }

    public String toString() {
        return this.name;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public final int compareTo(@Nonnull Constant other) {
        int r;
        if (this == other) {
            return 0;
        }
        if (this.poolId != other.poolId() && (r = this.poolId.compareTo(other.poolId())) != 0) {
            return r;
        }
        if (this.id < other.id()) {
            return -1;
        }
        if (this.id > other.id()) {
            return 1;
        }
        throw new Error("failed to compare two different constants, this: " + this.name + ", that: " + other.name());
    }
}

