/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.Preconditions;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionUtils {
    public static final int INDEX_NOT_FOUND = -1;

    private CollectionUtils() {
    }

    public static <E> E getOrDefault(List<E> elements, int index, E def) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index);
        }
        if (elements == null || index >= elements.size()) {
            return def;
        }
        return elements.get(index);
    }

    public static <E> E firstOrDefault(List<E> elements, E def) {
        if (elements == null || elements.isEmpty()) {
            return def;
        }
        return elements.getFirst();
    }

    public static <E> E lastOrDefault(List<E> elements, E def) {
        if (elements == null || elements.isEmpty()) {
            return def;
        }
        return elements.getLast();
    }

    public static void removeFirstN(List<?> list, int n) {
        if (n <= 0 || list.isEmpty()) {
            return;
        }
        if (n == 1) {
            list.removeFirst();
        } else if (list.size() <= n) {
            list.clear();
        } else {
            list.subList(0, n).clear();
        }
    }

    public static void removeLastN(List<?> list, int n) {
        if (n <= 0 || list.isEmpty()) {
            return;
        }
        if (n == 1) {
            list.removeLast();
        } else if (list.size() <= n) {
            list.clear();
        } else {
            list.subList(list.size() - n, list.size()).clear();
        }
    }

    public static <E> E removeAt(List<E> list, int index, boolean ordered) {
        if (ordered) {
            return list.remove(index);
        }
        E deleted = list.get(index);
        int tailIndex = list.size() - 1;
        if (index < tailIndex) {
            list.set(index, list.get(tailIndex));
        }
        list.remove(tailIndex);
        return deleted;
    }

    public static <E> int unorderedRemoveIf(List<E> list, Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        int originSize = list.size();
        if (originSize == 0) {
            return 0;
        }
        int size = originSize;
        int index = 0;
        while (index < size) {
            E e = list.get(index);
            if (!filter.test(e)) {
                ++index;
                continue;
            }
            if (index < --size) {
                list.set(index, list.get(size));
            }
            list.remove(size);
        }
        return originSize - size;
    }

    public static int indexOf(List<?> list, Object element) {
        return CollectionUtils.indexOf(list, element, 0, list.size());
    }

    public static int lastIndexOf(List<?> list, Object element) {
        return CollectionUtils.lastIndexOf(list, element, 0, list.size());
    }

    public static int indexOf(List<?> list, Object element, int start, int end) {
        Objects.requireNonNull(list, "list");
        if (element == null) {
            for (int i = start; i < end; ++i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!element.equals(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(List<?> list, Object element, int start, int end) {
        if (element == null) {
            for (int i = end - 1; i >= start; --i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                if (!element.equals(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean containsRef(List<?> list, Object element) {
        return CollectionUtils.indexOfRef(list, element, 0, list.size()) >= 0;
    }

    public static int indexOfRef(List<?> list, Object element) {
        return CollectionUtils.indexOfRef(list, element, 0, list.size());
    }

    public static int lastIndexOfRef(List<?> list, Object element) {
        return CollectionUtils.lastIndexOfRef(list, element, 0, list.size());
    }

    public static int indexOfRef(List<?> list, Object element, int start, int end) {
        Objects.requireNonNull(list, "list");
        if (element == null) {
            for (int i = start; i < end; ++i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (element != list.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfRef(List<?> list, Object element, int start, int end) {
        if (element == null) {
            for (int i = end - 1; i >= start; --i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                if (element != list.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean removeRef(List<?> list, Object element) {
        int index = CollectionUtils.indexOfRef(list, element);
        if (index < 0) {
            return false;
        }
        list.remove(index);
        return true;
    }

    public static boolean removeRef(List<?> list, Object element, boolean ordered) {
        int index = CollectionUtils.indexOfRef(list, element);
        if (index < 0) {
            return false;
        }
        CollectionUtils.removeAt(list, index, ordered);
        return true;
    }

    public static <E> boolean containsCustom(List<E> list, Predicate<? super E> indexFunc) {
        return CollectionUtils.indexOfCustom(list, indexFunc, 0, list.size()) >= 0;
    }

    public static <E> int indexOfCustom(List<E> list, Predicate<? super E> indexFunc) {
        return CollectionUtils.indexOfCustom(list, indexFunc, 0, list.size());
    }

    public static <E> int lastIndexOfCustom(List<E> list, Predicate<? super E> indexFunc) {
        return CollectionUtils.lastIndexOfCustom(list, indexFunc, 0, list.size());
    }

    public static <E> int indexOfCustom(List<E> list, Predicate<? super E> indexFunc, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!indexFunc.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <E> int lastIndexOfCustom(List<E> list, Predicate<? super E> indexFunc, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (!indexFunc.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> int binarySearch(List<T> array, T key, Comparator<? super T> c) {
        return CollectionUtils.binarySearch0(array, key, 0, array.size(), c);
    }

    public static <T> int binarySearch(List<T> array, T key, int fromIndex, int toIndex, Comparator<? super T> c) {
        ArrayUtils.rangeCheck(array.size(), fromIndex, toIndex);
        return CollectionUtils.binarySearch0(array, key, fromIndex, toIndex, c);
    }

    public static <T> int binarySearch(List<T> array, ToIntFunction<? super T> c) {
        return CollectionUtils.binarySearch0(array, 0, array.size(), c);
    }

    public static <T> int binarySearch(List<T> array, int fromIndex, int toIndex, ToIntFunction<? super T> c) {
        ArrayUtils.rangeCheck(array.size(), fromIndex, toIndex);
        return CollectionUtils.binarySearch0(array, fromIndex, toIndex, c);
    }

    private static <T> int binarySearch0(List<T> array, T key, int fromIndex, int toIndex, Comparator<? super T> c) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            T midVal = array.get(mid);
            int cmp = c.compare(key, midVal);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static <T> int binarySearch0(List<T> array, int fromIndex, int toIndex, ToIntFunction<? super T> c) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            T midVal = array.get(mid);
            int cmp = c.applyAsInt(midVal);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E a) {
        ArrayList<E> result = new ArrayList<E>(1);
        result.add(a);
        return result;
    }

    public static <E> ArrayList<E> newArrayList(E a, E b) {
        ArrayList<E> result = new ArrayList<E>(2);
        result.add(a);
        result.add(b);
        return result;
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... array) {
        return new ArrayList<E>(new ToArrayHelper<E>(array, 0, array.length));
    }

    public static <E> boolean addAll(ArrayList<E> self, Collection<? extends E> other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        return self.addAll(other);
    }

    public static <E> boolean removeAll(ArrayList<E> self, Collection<? extends E> other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        return self.removeAll(other);
    }

    public static <E> List<E> union(List<E> first, List<? extends E> second) {
        int size = first.size() + second.size();
        ArrayList result = new ArrayList(size);
        CollectionUtils.addAll(result, first);
        CollectionUtils.addAll(result, second);
        return result;
    }

    @SafeVarargs
    public static <E> List<E> union(List<E> first, List<? extends E> second, List<E> ... more) {
        int size = first.size() + second.size();
        for (List<E> m : more) {
            size = Math.addExact(size, m.size());
        }
        ArrayList result = new ArrayList(size);
        CollectionUtils.addAll(result, first);
        CollectionUtils.addAll(result, second);
        for (List<E> m : more) {
            CollectionUtils.addAll(result, m);
        }
        return result;
    }

    @Nonnull
    public static <E> List<E> toImmutableList(@Nullable Collection<E> src) {
        return src == null || src.isEmpty() ? List.of() : List.copyOf(src);
    }

    @Nonnull
    public static <E> List<E> toImmutableList(@Nullable Collection<E> src, Comparator<? super E> comparator) {
        if (src == null || src.isEmpty()) {
            return List.of();
        }
        Object[] elements = src.toArray();
        Arrays.sort(elements, comparator);
        return List.of(elements);
    }

    public static <E> List<E> nullToArrayList(@Nullable List<E> src) {
        return src == null ? new ArrayList() : src;
    }

    public static <E> List<E> nullToEmptyList(@Nullable List<E> src) {
        return src == null ? List.of() : src;
    }

    public static <E> HashSet<E> newHashSet(int size) {
        return new HashSet(CollectionUtils.capacity(size));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(int size) {
        return new LinkedHashSet(CollectionUtils.capacity(size));
    }

    public static <E> Set<E> newIdentityHashSet(int size) {
        return Collections.newSetFromMap(new IdentityHashMap(size));
    }

    @Nonnull
    public static <E> Set<E> toImmutableSet(@Nullable Collection<E> src) {
        if (src == null || src.isEmpty()) {
            return Set.of();
        }
        if (src.getClass() == HashSet.class) {
            return Set.of(src.toArray());
        }
        return Set.copyOf(src);
    }

    public static <E> Set<E> toImmutableLinkedHashSet(@Nullable Collection<E> src) {
        if (src == null || src.isEmpty()) {
            return Set.of();
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(src));
    }

    public static <E extends Enum<E>> Set<E> toImmutableEnumSet(@Nullable Collection<E> src, Class<E> keyType) {
        if (src == null || src.isEmpty()) {
            return Set.of();
        }
        EnumSet<E> enumSet = EnumSet.noneOf(keyType);
        enumSet.addAll(src);
        return Collections.unmodifiableSet(enumSet);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(CollectionUtils.capacity(size));
    }

    public static <K, V> HashMap<K, V> newHashMap(K k, V v) {
        HashMap<K, V> map = new HashMap<K, V>(4);
        map.put(k, v);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(K k, V v, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>(4);
        map.put(k, v);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int size) {
        return new LinkedHashMap(CollectionUtils.capacity(size));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(K k, V v) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(4);
        map.put(k, v);
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(K k, V v, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(4);
        map.put(k, v);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> V getOrThrow(Map<K, V> map, K key) {
        V v = map.get(key);
        if (v == null && !map.containsKey(key)) {
            throw new IllegalArgumentException(String.format("key is absent, key %s", key));
        }
        return v;
    }

    public static <K, V> V getOrThrow(Map<K, V> map, K key, String property) {
        V v = map.get(key);
        if (v == null && !map.containsKey(key)) {
            throw new IllegalArgumentException(String.format("%s is absent, key %s", ObjectUtils.nullToDef(property, "key"), key));
        }
        return v;
    }

    public static <K> K firstKey(Map<K, ?> map) {
        if (map instanceof SequencedMap) {
            SequencedMap sequencedMap = (SequencedMap)map;
            return sequencedMap.firstEntry().getKey();
        }
        return map.keySet().iterator().next();
    }

    public static <K, V> Map.Entry<K, V> firstEntry(Map<K, V> map) {
        if (map instanceof SequencedMap) {
            SequencedMap sequencedMap = (SequencedMap)map;
            return sequencedMap.firstEntry();
        }
        return map.entrySet().iterator().next();
    }

    public static <K, V> Map<V, K> inverseMap(Map<K, V> src) {
        HashMap out = CollectionUtils.newHashMap(src.size());
        src.forEach((k, v) -> out.put(v, k));
        return out;
    }

    public static <K, V> Map<V, K> inverseMap(Map<K, V> src, Map<V, K> out) {
        src.forEach((k, v) -> out.put(v, k));
        return out;
    }

    @Nonnull
    public static <K, V> Map<K, V> toImmutableMap(@Nullable Map<K, V> src) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        return Map.copyOf(src);
    }

    @Nonnull
    public static <K, V> Map<K, List<V>> toImmutableMultiMap(@Nullable Map<K, ? extends Collection<V>> src) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        HashMap copiedMap = new HashMap();
        src.forEach((k, v) -> copiedMap.put(k, List.copyOf(v)));
        return Map.copyOf(copiedMap);
    }

    public static <K, V> Map<K, V> toImmutableLinkedHashMap(@Nullable Map<K, V> src) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(src));
    }

    @Nonnull
    public static <K, V> Map<K, List<V>> toImmutableMultiLinkedHashMap(@Nullable Map<K, ? extends Collection<V>> src) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap copiedMap = new LinkedHashMap();
        src.forEach((k, v) -> copiedMap.put(k, List.copyOf(v)));
        return Collections.unmodifiableMap(copiedMap);
    }

    @Nonnull
    public static <K extends Enum<K>, V> Map<K, V> toImmutableEnumMap(@Nullable Map<K, V> src, Class<K> keyType) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        EnumMap<K, V> copiedMap = new EnumMap<K, V>(keyType);
        copiedMap.putAll(src);
        return Collections.unmodifiableMap(copiedMap);
    }

    @Nonnull
    public static <K extends Enum<K>, V> Map<K, List<V>> toImmutableMultiEnumMap(@Nullable Map<K, ? extends Collection<V>> src, Class<K> keyType) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        EnumMap copiedMap = new EnumMap(keyType);
        src.forEach((k, vs) -> copiedMap.put((Object)k, List.copyOf(vs)));
        return Collections.unmodifiableMap(copiedMap);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static void clear(@Nullable Collection<?> collection) {
        if (collection != null) {
            collection.clear();
        }
    }

    public static void clear(@Nullable Map<?, ?> map) {
        if (map != null) {
            map.clear();
        }
    }

    public static boolean joint(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        return !Collections.disjoint(source, candidates);
    }

    public static boolean disjoint(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return true;
        }
        return Collections.disjoint(source, candidates);
    }

    public static <E> E first(Collection<E> elements) {
        if (elements instanceof SequencedCollection) {
            SequencedCollection sequenced = (SequencedCollection)elements;
            return sequenced.getFirst();
        }
        return elements.iterator().next();
    }

    public static <E> boolean removeFirstMatch(Collection<E> collection, Predicate<? super E> predicate) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<E> itr = collection.iterator();
        while (itr.hasNext()) {
            if (!predicate.test(itr.next())) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public static boolean removeRef(Collection<?> collection, Object element) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != element) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static <T> Stream<T> streamOf(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> streamOf(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static int capacity(int numMappings) {
        Preconditions.checkNonNegative(numMappings, "numMappings");
        if (numMappings < 3) {
            return 4;
        }
        return (int)Math.ceil((double)numMappings / 0.75);
    }

    static class ToArrayHelper<E>
    extends AbstractCollection<E> {
        final E[] array;
        final int offset;
        final int length;

        public ToArrayHelper(E[] array, int offset, int length) {
            this.array = Objects.requireNonNull(array);
            this.offset = offset;
            this.length = length;
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            if (this.offset == 0 && this.length == this.array.length) {
                return this.array;
            }
            Object[] dest = new Object[this.length];
            System.arraycopy(this.array, this.offset, dest, 0, this.length);
            return dest;
        }

        @Override
        @Nonnull
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.length;
        }
    }
}

