/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.function;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.Predicate;

public class FunctionUtils {
    private static final IntConsumer _emptyIntConsumer = v -> {};
    private static final LongConsumer _emptyLongConsumer = v -> {};
    private static final DoubleConsumer _emptyDoubleConsumer = v -> {};
    private static final Runnable _emptyRunnable = () -> {};
    private static final Function<?, ?> identity = t -> t;
    private static final Consumer<?> _emptyConsumer = v -> {};
    private static final BiConsumer<?, ?> _emptyBiConsumer = (a, b) -> {};
    private static final Predicate<?> _alwaysTrue = v -> true;
    private static final Predicate<?> _alwaysFalse = v -> false;
    private static final BiPredicate<?, ?> _biAlwaysTrue = (t, u) -> true;
    private static final BiPredicate<?, ?> _biAlwaysFalse = (t, u) -> false;
    private static final Function<?, String> _toString = Object::toString;
    private static final Predicate<?> _notNull = Objects::nonNull;
    private static final Predicate<?> _isNull = Objects::isNull;

    public static IntConsumer emptyIntConsumer() {
        return _emptyIntConsumer;
    }

    public static LongConsumer emptyLongConsumer() {
        return _emptyLongConsumer;
    }

    public static DoubleConsumer emptyDoubleConsumer() {
        return _emptyDoubleConsumer;
    }

    public static Runnable emptyRunnable() {
        return _emptyRunnable;
    }

    public static <T> Function<T, T> identity() {
        return identity;
    }

    public static <T> Consumer<T> emptyConsumer() {
        return _emptyConsumer;
    }

    public static <T, U> BiConsumer<T, U> emptyBiConsumer() {
        return _emptyBiConsumer;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return _alwaysTrue;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return _alwaysFalse;
    }

    public static <T, U> BiPredicate<T, U> biAlwaysTrue() {
        return _biAlwaysTrue;
    }

    public static <T, U> BiPredicate<T, U> biAlwaysFalse() {
        return _biAlwaysFalse;
    }

    public static <T> Function<T, String> toStringFunction() {
        return _toString;
    }

    public static <T> Predicate<T> isNull() {
        return _isNull;
    }

    public static <T> Predicate<T> notNull() {
        return _notNull;
    }

    public static <T, R> Function<T, R> toFunction(Consumer<T> action, R result) {
        if (action == null) {
            throw new NullPointerException();
        }
        return t -> {
            action.accept(t);
            return result;
        };
    }

    public static <T> Function<T, Object> toFunction(Consumer<T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return t -> {
            action.accept(t);
            return null;
        };
    }

    public static <T, R> Consumer<T> toConsumer(Function<T, R> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        return function::apply;
    }

    public static <T, U, R> BiFunction<T, U, R> toBiFunction(BiConsumer<T, U> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return (t, u) -> {
            action.accept(t, u);
            return null;
        };
    }

    public static <T, U, R> BiFunction<T, U, R> toBiFunction(BiConsumer<T, U> action, R r) {
        if (action == null) {
            throw new NullPointerException();
        }
        return (t, u) -> {
            action.accept(t, u);
            return r;
        };
    }

    public static <T, U, R> BiConsumer<T, U> toBiConsumer(BiFunction<T, U, R> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        return function::apply;
    }
}

