/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.mutable;

import cn.wjybxx.base.mutable.MutableNumber;

public class MutableDouble
extends Number
implements MutableNumber<Double>,
Comparable<MutableDouble> {
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value) {
        this.value = value;
    }

    public MutableDouble(Number value) {
        this.value = value.doubleValue();
    }

    public MutableDouble(String value) {
        this.value = Double.parseDouble(value);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public void add(double operand) {
        this.value += operand;
    }

    public double addAndGet(double operand) {
        this.value += operand;
        return this.value;
    }

    public double getAndAdd(double operand) {
        double last = this.value;
        this.value += operand;
        return last;
    }

    public void increment() {
        this.value += 1.0;
    }

    public double incrementAndGet() {
        return this.value += 1.0;
    }

    public double getAndIncrement() {
        double d = this.value;
        this.value = d + 1.0;
        return d;
    }

    public void decrement() {
        this.value -= 1.0;
    }

    public double decrementAndGet() {
        return this.value -= 1.0;
    }

    public double getAndDecrement() {
        double d = this.value;
        this.value = d - 1.0;
        return d;
    }

    public MutableDouble add(Number operand) {
        this.value += operand.doubleValue();
        return this;
    }

    public MutableDouble subtract(Number operand) {
        this.value -= operand.doubleValue();
        return this;
    }

    public MutableDouble multiply(Number operand) {
        this.value *= operand.doubleValue();
        return this;
    }

    public MutableDouble divide(Number operand) {
        this.value /= operand.doubleValue();
        return this;
    }

    @Override
    public int compareTo(MutableDouble that) {
        return Double.compare(this.value, that.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableDouble that = (MutableDouble)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return "MutableDouble{value=" + this.value + "}";
    }
}

