/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.MathCommon;
import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.function.FunctionUtils;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DefaultObjectPool<T>
implements ObjectPool<T> {
    private static final int DEFAULT_POOL_SIZE = 64;
    private final Supplier<? extends T> factory;
    private final Consumer<? super T> resetHandler;
    private final Predicate<? super T> filter;
    private final int poolSize;
    private final ArrayList<T> freeObjects;

    public DefaultObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler) {
        this(factory, resetHandler, 64, null);
    }

    public DefaultObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler, int poolSize) {
        this(factory, resetHandler, poolSize, null);
    }

    public DefaultObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler, int poolSize, Predicate<? super T> filter) {
        if (poolSize < 0) {
            throw new IllegalArgumentException("poolSize: " + poolSize);
        }
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetHandler = ObjectUtils.nullToDef(resetHandler, FunctionUtils.emptyConsumer());
        this.filter = filter;
        this.poolSize = poolSize;
        this.freeObjects = new ArrayList(MathCommon.clamp(poolSize, 0, 10));
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public T get() {
        return this.acquire();
    }

    @Override
    public T acquire() {
        int size = this.freeObjects.size();
        if (size > 0) {
            return this.freeObjects.remove(size - 1);
        }
        return this.factory.get();
    }

    @Override
    public void release(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj cannot be null.");
        }
        this.resetHandler.accept(obj);
        if (this.freeObjects.size() < this.poolSize && (this.filter == null || this.filter.test(obj))) {
            this.freeObjects.add(obj);
        }
    }

    @Override
    public void releaseAll(Collection<? extends T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        ArrayList<T> freeObjects = this.freeObjects;
        Consumer<Object> resetPolicy = this.resetHandler;
        Predicate<Object> filter = this.filter;
        int poolSize = this.poolSize;
        if (objects instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)objects;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object obj = arrayList.get(i);
                if (null == obj) continue;
                resetPolicy.accept(obj);
                if (freeObjects.size() >= poolSize || filter != null && !filter.test(obj)) continue;
                freeObjects.add(obj);
            }
        } else {
            for (T obj : objects) {
                if (null == obj) continue;
                resetPolicy.accept(obj);
                if (freeObjects.size() >= poolSize || filter != null && !filter.test(obj)) continue;
                freeObjects.add(obj);
            }
        }
    }

    @Override
    public void clear() {
        this.freeObjects.clear();
    }
}

