/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.concurrent;

import cn.wjybxx.base.concurrent.CancelCodes;
import cn.wjybxx.base.concurrent.StacklessCancellationException;
import java.util.Objects;
import java.util.concurrent.CancellationException;

public class BetterCancellationException
extends CancellationException {
    private final int code;

    public BetterCancellationException(int code) {
        super(BetterCancellationException.formatMessage(code, null));
        this.code = CancelCodes.checkCode(code);
    }

    public BetterCancellationException(int code, String message) {
        super(BetterCancellationException.formatMessage(code, message));
        this.code = CancelCodes.checkCode(code);
    }

    public int getCode() {
        return this.code;
    }

    private static String formatMessage(int code, String message) {
        if (message == null) {
            return "The task was canceled, code: " + code;
        }
        return String.format("The task was canceled, code: %d, message: %s", code, message);
    }

    public static BetterCancellationException capture(Exception ex) {
        BetterCancellationException r;
        Objects.requireNonNull(ex);
        if (ex instanceof StacklessCancellationException) {
            StacklessCancellationException slex = (StacklessCancellationException)ex;
            return new BetterCancellationException(slex.getCode(), slex.getMessage());
        }
        if (ex instanceof BetterCancellationException) {
            BetterCancellationException ex2 = (BetterCancellationException)ex;
            r = new BetterCancellationException(ex2.getCode(), ex.getMessage());
        } else {
            r = new BetterCancellationException(1);
        }
        r.initCause(ex);
        return r;
    }
}

