/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

public interface ObjectPool<T>
extends Supplier<T> {
    @Override
    default public T get() {
        return this.acquire();
    }

    public T acquire();

    public void release(T var1);

    default public void releaseAll(Collection<? extends T> objects) {
        if (objects instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)objects;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object obj = arrayList.get(i);
                if (null == obj) continue;
                this.release(obj);
            }
        } else {
            for (T obj : objects) {
                if (null == obj) continue;
                this.release(obj);
            }
        }
    }

    public void clear();
}

