/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.collection.IndexedElementHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DelayedCompressList<E> {
    private Object[] elements;
    private final IndexedElementHelper<? super E> helper;
    private final float loadFactor;
    private int size;
    private int realSize;
    private int firstNullIndex = -1;
    private int recursionDepth;

    public DelayedCompressList() {
        this(8, 0.75f, null);
    }

    public DelayedCompressList(int initCapacity) {
        this(initCapacity, 0.75f, null);
    }

    public DelayedCompressList(int initCapacity, float loadFactor) {
        this(initCapacity, loadFactor, null);
    }

    public DelayedCompressList(int initCapacity, float loadFactor, IndexedElementHelper<? super E> helper) {
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor: " + loadFactor);
        }
        this.elements = new Object[initCapacity];
        this.loadFactor = loadFactor;
        this.helper = helper;
    }

    public void beginItr() {
        ++this.recursionDepth;
    }

    public void endItr() {
        if (this.recursionDepth == 0) {
            throw new IllegalStateException("begin must be called before end.");
        }
        --this.recursionDepth;
        if (this.recursionDepth == 0 && this.isCompressionNeeded()) {
            this.removeNullElements();
        }
    }

    public void compress(boolean force) {
        this.ensureNotIterating();
        if (force || this.isCompressionNeeded()) {
            this.removeNullElements();
        }
    }

    private boolean isCompressionNeeded() {
        return this.size - this.realSize > 3 && (float)this.realSize < (float)this.size * this.loadFactor;
    }

    public float currentLoad() {
        if (this.realSize == 0) {
            return 0.0f;
        }
        if (this.realSize == this.size) {
            return 1.0f;
        }
        return (float)this.realSize / (float)this.size;
    }

    public boolean isIterating() {
        return this.recursionDepth > 0;
    }

    public boolean add(E e) {
        Objects.requireNonNull(e);
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (this.helper != null) {
            this.helper.collectionIndex(this, e, this.size);
        }
        this.elements[this.size++] = e;
        ++this.realSize;
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends E> c) {
        Object[] array = c.toArray();
        if (array.length == 0) {
            return false;
        }
        for (Object e : array) {
            Objects.requireNonNull(e, "collection contains null element");
        }
        this.ensureCapacity(this.size + array.length);
        System.arraycopy(array, 0, this.elements, this.size, array.length);
        if (this.helper != null) {
            this.batchUpdateIndex(this.elements, this.size, this.size + array.length, this.helper);
        }
        this.size += array.length;
        this.realSize += array.length;
        return true;
    }

    public void insert(int index, E e) {
        Objects.requireNonNull(e);
        this.ensureNotIterating();
        if (index == this.size) {
            this.add(e);
        } else {
            Objects.checkIndex(index, this.size);
            if (this.elements[index] == null) {
                this.set(index, e);
                return;
            }
            if (this.size == this.elements.length) {
                this.ensureCapacity(this.size + 1);
            }
            if (this.helper != null) {
                this.helper.collectionIndex(this, e, index);
            }
            System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
            if (this.helper != null) {
                this.batchUpdateIndex(this.elements, index + 1, this.size, this.helper);
            }
            if (this.firstNullIndex >= index) {
                ++this.firstNullIndex;
            }
            this.elements[index] = e;
            ++this.realSize;
            ++this.size;
        }
    }

    @Nullable
    public E get(int index) {
        Objects.checkIndex(index, this.size);
        return (E)this.elements[index];
    }

    public E set(int index, E e) {
        Objects.checkIndex(index, this.size);
        Object ele = this.elements[index];
        if (e == null) {
            if (ele == null) {
                return null;
            }
            if (this.helper != null) {
                this.helper.collectionIndex(this, ele, -1);
            }
            this.elements[index] = null;
            --this.realSize;
            if (this.firstNullIndex > index || this.firstNullIndex == -1) {
                this.firstNullIndex = index;
            }
            if (this.recursionDepth == 0 && this.isCompressionNeeded()) {
                this.removeNullElements();
            }
            return (E)ele;
        }
        if (ele != null) {
            if (this.helper != null) {
                this.helper.collectionIndex(this, ele, -1);
                this.helper.collectionIndex(this, e, index);
            }
            this.elements[index] = e;
            return (E)ele;
        }
        this.insertSet(index, e);
        return null;
    }

    private void insertSet(int index, E e) {
        if (this.helper != null) {
            this.helper.collectionIndex(this, e, index);
        }
        this.elements[index] = e;
        ++this.realSize;
        if (index == this.firstNullIndex) {
            this.firstNullIndex = this.indexNextNullElement(index + 1);
        }
    }

    public E removeAt(int index) {
        return this.set(index, null);
    }

    public boolean remove(Object e) {
        if (e == null) {
            return false;
        }
        int i = this.index(e);
        if (i >= 0) {
            this.set(i, null);
            return true;
        }
        return false;
    }

    public boolean removeRef(Object e) {
        if (e == null) {
            return false;
        }
        int i = this.indexOfRef(e);
        if (i >= 0) {
            this.set(i, null);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        if (this.helper != null) {
            this.batchUnsetIndex(this.elements, 0, this.size, this.helper);
        } else {
            Arrays.fill(this.elements, 0, this.size, null);
        }
        this.realSize = 0;
        if (this.recursionDepth == 0) {
            this.size = 0;
            this.firstNullIndex = -1;
        } else {
            this.firstNullIndex = 0;
        }
    }

    public boolean contains(Object e) {
        return this.index(e) >= 0;
    }

    public boolean containsRef(Object e) {
        return this.indexOfRef(e) >= 0;
    }

    public int index(@Nullable Object e) {
        if (e != null && this.helper != null) {
            Object castE = e;
            return this.helper.collectionIndex(this, castE);
        }
        return ArrayUtils.indexOf(this.elements, e, 0, this.size);
    }

    public int lastIndex(@Nullable Object e) {
        if (e != null && this.helper != null) {
            Object castE = e;
            return this.helper.collectionIndex(this, castE);
        }
        return ArrayUtils.lastIndexOf(this.elements, e, 0, this.size);
    }

    public int indexOfRef(@Nullable Object e) {
        if (e != null && this.helper != null) {
            Object castE = e;
            return this.helper.collectionIndex(this, castE);
        }
        return ArrayUtils.indexOfRef(this.elements, e, 0, this.size);
    }

    public int lastIndexOfRef(@Nullable Object e) {
        if (e != null && this.helper != null) {
            Object castE = e;
            return this.helper.collectionIndex(this, castE);
        }
        return ArrayUtils.lastIndexOfRef(this.elements, e, 0, this.size);
    }

    public int indexCustom(Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Object[] elements = this.elements;
        return ArrayUtils.indexOfCustom(elements, predicate, 0, this.size);
    }

    public int lastIndexCustom(Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Object[] elements = this.elements;
        return ArrayUtils.lastIndexOfCustom(elements, predicate, 0, this.size);
    }

    public void sort(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        this.ensureNotIterating();
        if (this.realSize < this.size) {
            this.removeNullElements();
        }
        Object[] elements = this.elements;
        Arrays.sort(elements, 0, this.size, comparator);
        if (this.helper != null) {
            this.batchUpdateIndex(elements, 0, this.size, this.helper);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int elementCount() {
        return this.realSize;
    }

    public int nullCount() {
        return this.size - this.realSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int size = this.size;
        if (size == 0) {
            return;
        }
        Object[] elements = this.elements;
        this.beginItr();
        try {
            for (int index = 0; index < size; ++index) {
                Object e = elements[index];
                if (e == null) continue;
                action.accept(e);
            }
        }
        finally {
            this.endItr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(ObjIntConsumer<? super E> action) {
        Objects.requireNonNull(action);
        int size = this.size;
        if (size == 0) {
            return;
        }
        Object[] elements = this.elements;
        this.beginItr();
        try {
            for (int index = 0; index < size; ++index) {
                Object e = elements[index];
                if (e == null) continue;
                action.accept(e, index);
            }
        }
        finally {
            this.endItr();
        }
    }

    public List<E> toList() {
        if (this.realSize == 0) {
            return new ArrayList();
        }
        Object[] elements = this.elements;
        if (this.realSize == this.size) {
            return ArrayUtils.toList(elements, 0, this.size);
        }
        ArrayList<Object> result = new ArrayList<Object>(this.realSize);
        int end = this.size;
        for (int i = 0; i < end; ++i) {
            Object e = elements[i];
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    private void ensureNotIterating() {
        if (this.recursionDepth != 0) {
            throw new IllegalStateException("Invalid between iterating.");
        }
    }

    private void removeNullElements() {
        int nextIndex;
        if (this.realSize == this.size) {
            return;
        }
        if (this.realSize == 0) {
            this.size = 0;
            this.firstNullIndex = -1;
            return;
        }
        Object[] elements = this.elements;
        IndexedElementHelper<Object> helper = this.helper;
        int firstNullIndex = this.firstNullIndex;
        int nullCount = this.size - this.realSize;
        int end = this.size;
        for (nextIndex = firstNullIndex + 1; nextIndex < end && nextIndex - firstNullIndex < nullCount; ++nextIndex) {
            Object element = elements[nextIndex];
            if (element == null) continue;
            if (helper != null) {
                Object castE = element;
                helper.collectionIndex(this, castE, firstNullIndex);
            }
            elements[firstNullIndex++] = element;
        }
        if (nextIndex < this.size) {
            System.arraycopy(elements, nextIndex, elements, firstNullIndex, this.size - nextIndex);
        }
        Arrays.fill(elements, this.realSize, this.size, null);
        this.size = this.realSize;
        this.firstNullIndex = -1;
    }

    private int indexNextNullElement(int start) {
        if (this.realSize == this.size) {
            return -1;
        }
        Object[] elements = this.elements;
        int end = this.size;
        for (int index = start; index < end; ++index) {
            if (elements[index] != null) continue;
            return index;
        }
        throw new IllegalStateException();
    }

    private void batchUpdateIndex(Object[] elements, int start, int end, IndexedElementHelper<? super E> helper) {
        for (int index = start; index < end; ++index) {
            Object castE = elements[index];
            if (castE == null) continue;
            helper.collectionIndex(this, castE, index);
        }
    }

    private void batchUnsetIndex(Object[] elements, int start, int end, IndexedElementHelper<? super E> helper) {
        for (int index = start; index < end; ++index) {
            Object castE = elements[index];
            if (castE == null) continue;
            helper.collectionIndex(this, castE, -1);
            elements[index] = null;
        }
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (minCapacity <= oldCapacity) {
            return;
        }
        int grow = oldCapacity >> 1;
        int newCapacity = Math.clamp((long)oldCapacity + (long)grow, 4, 0x7FFFFFF7);
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elements = Arrays.copyOf(this.elements, newCapacity);
    }
}

