/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.MathCommon;
import java.nio.Buffer;

public class ByteBufferUtils {
    public static void checkBuffer(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        ByteBufferUtils.checkBuffer(buffer.length, offset, length);
    }

    public static void checkBuffer(int bufferLength, int offset, int length) {
        if ((offset | length | bufferLength - (offset + length)) < 0) {
            throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", bufferLength, offset, length));
        }
    }

    public static void checkBuffer(int bufferLength, int offset) {
        if (offset < 0 || offset > bufferLength) {
            throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d", bufferLength, offset));
        }
    }

    public static void position(Buffer byteBuffer, int newOffset) {
        byteBuffer.position(newOffset);
    }

    public static byte getByte(byte[] buffer, int index) {
        return buffer[index];
    }

    public static void setByte(byte[] buffer, int index, byte value) {
        buffer[index] = value;
    }

    public static int getUnsignedByte(byte[] buffer, int index) {
        return buffer[index] & 0xFF;
    }

    public static void setByte(byte[] buffer, int index, int value) {
        buffer[index] = (byte)value;
    }

    public static void setInt16(byte[] buffer, int index, short value) {
        buffer[index] = (byte)(value >>> 8);
        buffer[index + 1] = (byte)value;
    }

    public static short getInt16(byte[] buffer, int index) {
        return (short)(buffer[index] << 8 | buffer[index + 1] & 0xFF);
    }

    public static void setInt32(byte[] buffer, int index, int value) {
        buffer[index] = (byte)(value >>> 24);
        buffer[index + 1] = (byte)(value >>> 16);
        buffer[index + 2] = (byte)(value >>> 8);
        buffer[index + 3] = (byte)value;
    }

    public static int getInt32(byte[] buffer, int index) {
        return (buffer[index] & 0xFF) << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
    }

    public static void setUInt32(byte[] buffer, int index, long value) {
        if (!MathCommon.isUInt32(value)) {
            throw new IllegalArgumentException("value: " + value);
        }
        buffer[index] = (byte)(value >>> 24);
        buffer[index + 1] = (byte)(value >>> 16);
        buffer[index + 2] = (byte)(value >>> 8);
        buffer[index + 3] = (byte)value;
    }

    public static long getUInt32(byte[] buffer, int index) {
        return ((long)buffer[index] & 0xFFL) << 24 | ((long)buffer[index + 1] & 0xFFL) << 16 | ((long)buffer[index + 2] & 0xFFL) << 8 | (long)buffer[index + 3] & 0xFFL;
    }

    public static void setUInt48(byte[] buffer, int index, long value) {
        if (!MathCommon.isUInt48(value)) {
            throw new IllegalArgumentException("value: " + value);
        }
        buffer[index] = (byte)(value >>> 40);
        buffer[index + 1] = (byte)(value >>> 32);
        buffer[index + 2] = (byte)(value >>> 24);
        buffer[index + 3] = (byte)(value >>> 16);
        buffer[index + 4] = (byte)(value >>> 8);
        buffer[index + 5] = (byte)value;
    }

    public static long getUInt48(byte[] buffer, int index) {
        return ((long)buffer[index] & 0xFFL) << 40 | ((long)buffer[index + 1] & 0xFFL) << 32 | ((long)buffer[index + 2] & 0xFFL) << 24 | ((long)buffer[index + 3] & 0xFFL) << 16 | ((long)buffer[index + 4] & 0xFFL) << 8 | (long)buffer[index + 5] & 0xFFL;
    }

    public static void setInt64(byte[] buffer, int index, long value) {
        buffer[index] = (byte)(value >>> 56);
        buffer[index + 1] = (byte)(value >>> 48);
        buffer[index + 2] = (byte)(value >>> 40);
        buffer[index + 3] = (byte)(value >>> 32);
        buffer[index + 4] = (byte)(value >>> 24);
        buffer[index + 5] = (byte)(value >>> 16);
        buffer[index + 6] = (byte)(value >>> 8);
        buffer[index + 7] = (byte)value;
    }

    public static long getInt64(byte[] buffer, int index) {
        return ((long)buffer[index] & 0xFFL) << 56 | ((long)buffer[index + 1] & 0xFFL) << 48 | ((long)buffer[index + 2] & 0xFFL) << 40 | ((long)buffer[index + 3] & 0xFFL) << 32 | ((long)buffer[index + 4] & 0xFFL) << 24 | ((long)buffer[index + 5] & 0xFFL) << 16 | ((long)buffer[index + 6] & 0xFFL) << 8 | (long)buffer[index + 7] & 0xFFL;
    }

    public static void setInt16LE(byte[] buffer, int index, short value) {
        buffer[index] = (byte)value;
        buffer[index + 1] = (byte)(value >>> 8);
    }

    public static short getInt16LE(byte[] buffer, int index) {
        return (short)(buffer[index] & 0xFF | buffer[index + 1] << 8);
    }

    public static void setInt32LE(byte[] buffer, int index, int value) {
        buffer[index] = (byte)value;
        buffer[index + 1] = (byte)(value >>> 8);
        buffer[index + 2] = (byte)(value >>> 16);
        buffer[index + 3] = (byte)(value >>> 24);
    }

    public static int getInt32LE(byte[] buffer, int index) {
        return buffer[index] & 0xFF | (buffer[index + 1] & 0xFF) << 8 | (buffer[index + 2] & 0xFF) << 16 | (buffer[index + 3] & 0xFF) << 24;
    }

    public static void setUInt32LE(byte[] buffer, int index, long value) {
        if (!MathCommon.isUInt32(value)) {
            throw new IllegalArgumentException("value: " + value);
        }
        buffer[index] = (byte)value;
        buffer[index + 1] = (byte)(value >>> 8);
        buffer[index + 2] = (byte)(value >>> 16);
        buffer[index + 3] = (byte)(value >>> 24);
    }

    public static long getUInt32LE(byte[] buffer, int index) {
        return (long)buffer[index] & 0xFFL | ((long)buffer[index + 1] & 0xFFL) << 8 | ((long)buffer[index + 2] & 0xFFL) << 16 | ((long)buffer[index + 3] & 0xFFL) << 24;
    }

    public static void setUInt48LE(byte[] buffer, int index, long value) {
        if (!MathCommon.isUInt48(value)) {
            throw new IllegalArgumentException("value: " + value);
        }
        buffer[index] = (byte)value;
        buffer[index + 1] = (byte)(value >>> 8);
        buffer[index + 2] = (byte)(value >>> 16);
        buffer[index + 3] = (byte)(value >>> 24);
        buffer[index + 4] = (byte)(value >>> 32);
        buffer[index + 5] = (byte)(value >>> 40);
    }

    public static long getUInt48LE(byte[] buffer, int index) {
        return (long)buffer[index] & 0xFFL | ((long)buffer[index + 1] & 0xFFL) << 8 | ((long)buffer[index + 2] & 0xFFL) << 16 | ((long)buffer[index + 3] & 0xFFL) << 24 | ((long)buffer[index + 4] & 0xFFL) << 32 | ((long)buffer[index + 5] & 0xFFL) << 40;
    }

    public static void setInt64LE(byte[] buffer, int index, long value) {
        buffer[index] = (byte)value;
        buffer[index + 1] = (byte)(value >>> 8);
        buffer[index + 2] = (byte)(value >>> 16);
        buffer[index + 3] = (byte)(value >>> 24);
        buffer[index + 4] = (byte)(value >>> 32);
        buffer[index + 5] = (byte)(value >>> 40);
        buffer[index + 6] = (byte)(value >>> 48);
        buffer[index + 7] = (byte)(value >>> 56);
    }

    public static long getInt64LE(byte[] buffer, int index) {
        return (long)buffer[index] & 0xFFL | ((long)buffer[index + 1] & 0xFFL) << 8 | ((long)buffer[index + 2] & 0xFFL) << 16 | ((long)buffer[index + 3] & 0xFFL) << 24 | ((long)buffer[index + 4] & 0xFFL) << 32 | ((long)buffer[index + 5] & 0xFFL) << 40 | ((long)buffer[index + 6] & 0xFFL) << 48 | ((long)buffer[index + 7] & 0xFFL) << 56;
    }
}

