/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import javax.annotation.Nonnull;

public class StringBuilderWriter
extends Writer {
    private final StringBuilder builder;

    public StringBuilderWriter() {
        this(null);
    }

    public StringBuilderWriter(int initialSize) {
        this(new StringBuilder(initialSize));
    }

    public StringBuilderWriter(StringBuilder builder) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        this.builder = builder;
        this.lock = builder;
    }

    @Override
    public void write(int c) {
        this.builder.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        Objects.checkFromIndexSize(off, len, cbuf.length);
        if (len == 0) {
            return;
        }
        this.builder.append(cbuf, off, len);
    }

    @Override
    public void write(@Nonnull String str) {
        this.builder.append(str);
    }

    @Override
    public void write(@Nonnull String str, int off, int len) {
        this.builder.append(str, off, off + len);
    }

    @Override
    public StringBuilderWriter append(CharSequence csq) {
        this.builder.append(csq);
        return this;
    }

    @Override
    public StringBuilderWriter append(CharSequence csq, int start, int end) {
        this.builder.append(csq, start, end);
        return this;
    }

    @Override
    public StringBuilderWriter append(char c) {
        this.builder.append(c);
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

