/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.SystemPropsUtils;
import cn.wjybxx.base.function.FunctionUtils;
import cn.wjybxx.base.pool.MpmcObjectBucket;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentObjectPool<T>
implements ObjectPool<T> {
    private static final int DEFAULT_POOL_SIZE = 64;
    private static final int SBP_MAX_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedStringBuilderPool.MaxCapacity", 65536);
    private static final int SBP_SIZE = SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedStringBuilderPool.PoolSize", 64);
    public static final ConcurrentObjectPool<StringBuilder> SHARED_STRING_BUILDER_POOL = new ConcurrentObjectPool<StringBuilder>(() -> new StringBuilder(1024), sb -> sb.setLength(0), SBP_SIZE, sb -> sb.capacity() >= 1024 && sb.capacity() <= SBP_MAX_CAPACITY);
    private final Supplier<? extends T> factory;
    private final Consumer<? super T> resetHandler;
    private final Predicate<? super T> filter;
    private final MpmcObjectBucket<T> freeObjects;

    public ConcurrentObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler) {
        this(factory, resetHandler, 64, null);
    }

    public ConcurrentObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler, int poolSize) {
        this(factory, resetHandler, poolSize, null);
    }

    public ConcurrentObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetHandler, int poolSize, Predicate<? super T> filter) {
        if (poolSize < 0) {
            throw new IllegalArgumentException("poolSize: " + poolSize);
        }
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetHandler = ObjectUtils.nullToDef(resetHandler, FunctionUtils.emptyConsumer());
        this.filter = filter;
        this.freeObjects = new MpmcObjectBucket(poolSize);
    }

    public int getPoolSize() {
        return this.freeObjects.getLength();
    }

    public int getAvailableCount() {
        return this.freeObjects.size();
    }

    @Override
    @Deprecated
    public T get() {
        return this.acquire();
    }

    @Override
    public T acquire() {
        T obj = this.freeObjects.poll();
        return obj != null ? obj : this.factory.get();
    }

    @Override
    public void release(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj cannot be null.");
        }
        this.resetHandler.accept(obj);
        if (this.filter == null || this.filter.test(obj)) {
            this.freeObjects.offer(obj);
        }
    }

    @Override
    public void clear() {
        while (this.freeObjects.poll() != null) {
        }
    }
}

