/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.random.RandomGenerator;

public class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] arrayRankSymbols = new String[]{"[]", "[][]", "[][][]", "[][][][]", "[][][][][]", "[][][][][][]", "[][][][][][][]", "[][][][][][][][]", "[][][][][][][][][]"};

    public static <T> int indexOf(T[] list, Object element) {
        return ArrayUtils.indexOf(list, element, 0, list.length);
    }

    public static <T> int lastIndexOf(T[] list, Object element) {
        return ArrayUtils.lastIndexOf(list, element, 0, list.length);
    }

    public static <T> int indexOf(T[] list, Object element, int start, int end) {
        if (element == null) {
            for (int i = start; i < end; ++i) {
                if (list[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!element.equals(list[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] list, Object element, int start, int end) {
        if (element == null) {
            for (int i = end - 1; i >= start; --i) {
                if (list[i] != null) continue;
                return i;
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                if (!element.equals(list[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean containsRef(T[] list, Object element) {
        return ArrayUtils.indexOfRef(list, element, 0, list.length) >= 0;
    }

    public static <T> int indexOfRef(T[] list, Object element) {
        return ArrayUtils.indexOfRef(list, element, 0, list.length);
    }

    public static <T> int lastIndexOfRef(T[] list, Object element) {
        return ArrayUtils.lastIndexOfRef(list, element, 0, list.length);
    }

    public static <T> int indexOfRef(T[] list, Object element, int start, int end) {
        if (element == null) {
            for (int i = start; i < end; ++i) {
                if (list[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (element != list[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOfRef(T[] list, Object element, int start, int end) {
        if (element == null) {
            for (int i = end - 1; i >= start; --i) {
                if (list[i] != null) continue;
                return i;
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                if (element != list[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean containsCustom(T[] list, Predicate<? super T> indexFunc) {
        return ArrayUtils.indexOfCustom(list, indexFunc, 0, list.length) >= 0;
    }

    public static <T> int indexOfCustom(T[] list, Predicate<? super T> indexFunc) {
        return ArrayUtils.indexOfCustom(list, indexFunc, 0, list.length);
    }

    public static <T> int lastIndexOfCustom(T[] list, Predicate<? super T> indexFunc) {
        return ArrayUtils.lastIndexOfCustom(list, indexFunc, 0, list.length);
    }

    public static <T> int indexOfCustom(T[] list, Predicate<? super T> indexFunc, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!indexFunc.test(list[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOfCustom(T[] list, Predicate<? super T> indexFunc, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (!indexFunc.test(list[i])) continue;
            return i;
        }
        return -1;
    }

    public static void swap(int[] array, int i, int j) {
        int value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(long[] array, int i, int j) {
        long value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(float[] array, int i, int j) {
        float value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(double[] array, int i, int j) {
        double value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(Object[] array, int i, int j) {
        Object value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void shuffle(int[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(long[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(float[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(double[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(Object[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static <T> int binarySearch(T[] array, ToIntFunction<? super T> c) {
        return ArrayUtils.binarySearch0(array, 0, array.length, c);
    }

    public static <T> int binarySearch(T[] array, int fromIndex, int toIndex, ToIntFunction<? super T> c) {
        ArrayUtils.rangeCheck(array.length, fromIndex, toIndex);
        return ArrayUtils.binarySearch0(array, fromIndex, toIndex, c);
    }

    private static <T> int binarySearch0(T[] array, int fromIndex, int toIndex, ToIntFunction<? super T> c) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            T midVal = array[mid];
            int cmp = c.applyAsInt(midVal);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static <E> List<E> asList(E[] array) {
        return Arrays.asList(array);
    }

    public static <E> List<E> asList(E[] array, int offset, int length) {
        if (offset == 0 && length == array.length) {
            return Arrays.asList(array);
        }
        return Arrays.asList(array).subList(offset, offset + length);
    }

    public static <E> ArrayList<E> toList(E[] array) {
        return new ArrayList<E>(new CollectionUtils.ToArrayHelper<E>(array, 0, array.length));
    }

    public static <E> ArrayList<E> toList(E[] array, int offset, int length) {
        return new ArrayList<E>(new CollectionUtils.ToArrayHelper<E>(array, offset, length));
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int idx = 0; idx < list.size(); ++idx) {
            int val;
            array[idx] = val = list.get(idx).intValue();
        }
        return array;
    }

    public static long[] toLongArray(List<Long> list) {
        long[] array = new long[list.size()];
        for (int idx = 0; idx < list.size(); ++idx) {
            long val;
            array[idx] = val = list.get(idx).longValue();
        }
        return array;
    }

    public static float[] toFloatArray(List<Float> list) {
        float[] array = new float[list.size()];
        for (int idx = 0; idx < list.size(); ++idx) {
            float val;
            array[idx] = val = list.get(idx).floatValue();
        }
        return array;
    }

    public static double[] toDoubleArray(List<Double> list) {
        double[] array = new double[list.size()];
        for (int idx = 0; idx < list.size(); ++idx) {
            double val;
            array[idx] = val = list.get(idx).doubleValue();
        }
        return array;
    }

    public static String arrayRankSymbol(int rank) {
        if (rank < 1 || rank > 9) {
            throw new IllegalArgumentException("rank: " + rank);
        }
        return arrayRankSymbols[rank - 1];
    }

    public static Class<?> getRootComponentType(Class<?> clz) {
        while (clz.isArray()) {
            clz = clz.getComponentType();
        }
        return clz;
    }

    public static int getArrayRank(Class<?> clz) {
        int r = 0;
        while (clz.isArray()) {
            ++r;
            clz = clz.getComponentType();
        }
        return r;
    }
}

