/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.Constant;
import cn.wjybxx.base.ConstantFactory;
import cn.wjybxx.base.ConstantMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class ConstantPool<T extends Constant> {
    private final ConcurrentMap<String, T> constants = new ConcurrentHashMap<String, T>();
    private final ConstantFactory<? extends T> factory;
    private final String poolId = UUID.randomUUID().toString();
    private final AtomicInteger idGenerator;
    private final AtomicInteger cacheIndexGenerator = new AtomicInteger(0);

    private ConstantPool(ConstantFactory<? extends T> factory, int firstId) {
        this.factory = factory;
        this.idGenerator = new AtomicInteger(firstId);
    }

    public static <T extends Constant> ConstantPool<T> newPool(ConstantFactory<? extends T> factory) {
        return ConstantPool.newPool(factory, 0);
    }

    public static <T extends Constant> ConstantPool<T> newPool(ConstantFactory<? extends T> factory, int firstId) {
        return new ConstantPool<T>(factory, firstId);
    }

    public final T valueOf(String name) {
        Constant.checkName(name);
        if (this.factory == null) {
            return this.getOrThrow(name);
        }
        return this.getOrCreate(name);
    }

    public final T newInstance(String name) {
        Constant.checkName(name);
        if (this.factory == null) {
            throw new IllegalStateException("builder required");
        }
        return this.createOrThrow(new SimpleBuilder<T>(name, this.factory));
    }

    public final T newInstance(Constant.Builder<? extends T> builder) {
        Objects.requireNonNull(builder, "builder");
        return this.createOrThrow(builder);
    }

    public final T valueOf(Constant.Builder<? extends T> builder) {
        Objects.requireNonNull(builder, "builder");
        return this.getOrCreate(builder);
    }

    public final boolean exists(String name) {
        Constant.checkName(name);
        return this.constants.containsKey(name);
    }

    @Nullable
    public final T get(String name) {
        Constant.checkName(name);
        return (T)((Constant)this.constants.get(name));
    }

    public final T getOrThrow(String name) {
        Constant.checkName(name);
        Constant constant = (Constant)this.constants.get(name);
        if (null == constant) {
            throw new IllegalArgumentException(name + " does not exist");
        }
        return (T)constant;
    }

    public final List<T> values() {
        ArrayList r = new ArrayList(this.constants.values());
        r.sort(Comparable::compareTo);
        return r;
    }

    public final int size() {
        return this.constants.size();
    }

    public final ConstantMap<T> newConstantMap() {
        return new ConstantMap(this);
    }

    private T getOrCreate(String name) {
        assert (this.factory != null);
        Constant constant = (Constant)this.constants.get(name);
        if (constant != null) {
            return (T)constant;
        }
        constant = this.newConstant(new SimpleBuilder<T>(name, this.factory));
        Constant exist = this.constants.putIfAbsent(name, constant);
        return (T)(exist == null ? constant : exist);
    }

    private T getOrCreate(Constant.Builder<? extends T> builder) {
        String name = builder.getName();
        Constant constant = (Constant)this.constants.get(name);
        if (constant != null) {
            return (T)constant;
        }
        constant = this.newConstant(builder);
        Constant exist = this.constants.putIfAbsent(name, constant);
        return (T)(exist == null ? constant : exist);
    }

    private T createOrThrow(Constant.Builder<? extends T> builder) {
        String name = builder.getName();
        Constant constant = (Constant)this.constants.get(name);
        if (constant == null && this.constants.putIfAbsent(name, constant = this.newConstant(builder)) == null) {
            return (T)constant;
        }
        throw new IllegalArgumentException(name + " is already in use");
    }

    private T newConstant(Constant.Builder<? extends T> builder) {
        int id = this.idGenerator.getAndIncrement();
        int cacheIndex = builder.isRequireCacheIndex() ? this.cacheIndexGenerator.getAndIncrement() : -1;
        builder.setId(this.poolId, id, cacheIndex);
        T result = builder.build();
        Objects.requireNonNull(result, "result");
        if (result.id() != id || !Objects.equals(result.name(), builder.getName()) || result.poolId() != this.poolId) {
            throw new IllegalStateException(String.format("expected id: %d, name: %s, but found id: %d, name: %s", id, builder.getName(), result.id(), result.name()));
        }
        return result;
    }

    private static class SimpleBuilder<T extends Constant>
    extends Constant.Builder<T> {
        private final ConstantFactory<T> factory;

        SimpleBuilder(String name, ConstantFactory<T> factory) {
            super(name);
            this.factory = Objects.requireNonNull(factory);
        }

        @Override
        protected T build() {
            return this.factory.newConstant(this);
        }
    }
}

