/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import java.util.Random;

public class MathCommon {
    public static final int MAX_POWER_OF_TWO = 0x40000000;
    public static final long LONG_MAX_POWER_OF_TWO = 0x4000000000000000L;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-5f;
    public static final float DOUBLE_ROUNDING_ERROR = 1.0E-9f;
    public static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    public static final long UINT48_MAX_VALUE = 0xFFFFFFFFFFFFL;
    public static final long INT48_MAX_VALUE = 0x7FFFFFFFFFFFL;
    public static final long INT48_MIN_VALUE = -140737488355328L;
    public static final int INT_MASK4 = -16777216;
    public static final int INT_MASK3 = 0xFF0000;
    public static final int INT_MASK2 = 65280;
    public static final int INT_MASK1 = 255;
    public static final long LONG_MASK8 = -72057594037927936L;
    public static final long LONG_MASK7 = 0xFF000000000000L;
    public static final long LONG_MASK6 = 0xFF0000000000L;
    public static final long LONG_MASK5 = 0xFF00000000L;
    public static final long LONG_MASK4 = 0xFF000000L;
    public static final long LONG_MASK3 = 0xFF0000L;
    public static final long LONG_MASK2 = 65280L;
    public static final long LONG_MASK1 = 255L;
    public static final Random SHARED_RANDOM = new Random();
    private static final int INT_M1 = 0x55555555;
    private static final int INT_M2 = 0x33333333;
    private static final int INT_M4 = 0xF0F0F0F;
    private static final int INT_M8 = 0xFF00FF;
    private static final int INT_M16 = 65535;
    private static final long LONG_M1 = 0x5555555555555555L;
    private static final long LONG_M2 = 0x3333333333333333L;
    private static final long LONG_M4 = 0xF0F0F0F0F0F0F0FL;
    private static final long LONG_M8 = 0xFF00FF00FF00FFL;
    private static final long LONG_M16 = 0xFFFF0000FFFFL;
    private static final long LONG_M32 = 0xFFFFFFFFL;

    protected MathCommon() {
    }

    public static boolean isEven(int x) {
        return (x & 1) == 0;
    }

    public static boolean isOdd(int x) {
        return (x & 1) == 1;
    }

    public static boolean isUInt32(long value) {
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    public static boolean isUInt48(long value) {
        return value >= 0L && value <= 0xFFFFFFFFFFFFL;
    }

    public static boolean isInt48(long value) {
        return value >= -140737488355328L && value <= 0x7FFFFFFFFFFFL;
    }

    public static boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static int nextPowerOfTwo(int num) {
        if (num < 1) {
            return 1;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(num - 1);
    }

    public static long nextPowerOfTwo(long num) {
        if (num < 1L) {
            return 1L;
        }
        return 1L << 64 - Long.numberOfLeadingZeros(num - 1L);
    }

    public static int bitCount(int n) {
        n = (n & 0x55555555) + (n >>> 1 & 0x55555555);
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = (n & 0xF0F0F0F) + (n >>> 4 & 0xF0F0F0F);
        n = (n & 0xFF00FF) + (n >>> 8 & 0xFF00FF);
        n = (n & 0xFFFF) + (n >>> 16 & 0xFFFF);
        return n;
    }

    public static int bitCount(long n) {
        n = (n & 0x5555555555555555L) + (n >>> 1 & 0x5555555555555555L);
        n = (n & 0x3333333333333333L) + (n >>> 2 & 0x3333333333333333L);
        n = (n & 0xF0F0F0F0F0F0F0FL) + (n >>> 4 & 0xF0F0F0F0F0F0F0FL);
        n = (n & 0xFF00FF00FF00FFL) + (n >>> 8 & 0xFF00FF00FF00FFL);
        n = (n & 0xFFFF0000FFFFL) + (n >>> 16 & 0xFFFF0000FFFFL);
        n = (n & 0xFFFFFFFFL) + (n >>> 32 & 0xFFFFFFFFL);
        return (int)n;
    }

    public static int BitCountFast(int n0) {
        int n = n0 >>> 1;
        int c = 0;
        while (n != 0) {
            n &= n - 1;
            ++c;
        }
        return n0 < 0 ? c + 1 : c;
    }

    public static int BitCountFast(long n0) {
        long n = n0 >>> 1;
        int c = 0;
        while (n != 0L) {
            n &= n - 1L;
            ++c;
        }
        return n0 < 0L ? c + 1 : c;
    }

    public static long composeIntToLong(int higher, int lower) {
        return (long)higher << 32 | (long)lower & 0xFFFFFFFFL;
    }

    public static int higherIntOfLong(long value) {
        return (int)(value >>> 32);
    }

    public static int lowerIntOfLong(long value) {
        return (int)value;
    }

    public static int composeShortToInt(short higher, short lower) {
        return higher << 16 | lower & 0xFFFF;
    }

    public static short higherShortOfInt(int value) {
        return (short)(value >>> 16);
    }

    public static short lowerShortOfInt(int value) {
        return (short)value;
    }

    public static long multiplyToLong(int a, int b) {
        return (long)a * (long)b;
    }

    public static int multiplyToInt(short a, short b) {
        return a * b;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(long value, int min, int max) {
        if (value < (long)min) {
            return min;
        }
        if (value > (long)max) {
            return max;
        }
        return (int)value;
    }

    public static float clamp(double value, float min, float max) {
        if (value < (double)min) {
            return min;
        }
        if (value > (double)max) {
            return max;
        }
        return (float)value;
    }

    public static float clamp01(float value) {
        if (value <= 0.0f) {
            return 0.0f;
        }
        if (value >= 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public static double clamp01(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= 1.0) {
            return 1.0;
        }
        return value;
    }

    public static int sumAndClamp(int value, int delta) {
        long r = (long)value + (long)delta;
        return MathCommon.clamp(r, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int sumAndClamp(int value, int delta, int min, int max) {
        long r = (long)value + (long)delta;
        return MathCommon.clamp(r, min, max);
    }

    public static int multiplyAndClamp(int value, int delta) {
        long r = (long)value * (long)delta;
        return MathCommon.clamp(r, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int multiplyAndClamp(int value, int delta, int min, int max) {
        long r = (long)value * (long)delta;
        return MathCommon.clamp(r, min, max);
    }

    public static int min(int a, int b, int c) {
        if (a > b) {
            a = b;
        }
        if (a > c) {
            a = c;
        }
        return a;
    }

    public static int max(int a, int b, int c) {
        if (a < b) {
            a = b;
        }
        if (a < c) {
            a = c;
        }
        return a;
    }

    public static long min(long a, long b, long c) {
        if (a > b) {
            a = b;
        }
        if (a > c) {
            a = c;
        }
        return a;
    }

    public static long max(long a, long b, long c) {
        if (a < b) {
            a = b;
        }
        if (a < c) {
            a = c;
        }
        return a;
    }

    public static float min(float a, float b, float c) {
        float r = Math.min(a, b);
        return Math.min(r, c);
    }

    public static float max(float a, float b, float c) {
        float r = Math.max(a, b);
        return Math.max(r, c);
    }

    public static double min(double a, double b, double c) {
        double r = Math.min(a, b);
        return Math.min(r, c);
    }

    public static double max(double a, double b, double c) {
        double r = Math.max(a, b);
        return Math.max(r, c);
    }

    public static int min(short a, short b) {
        return a < b ? a : b;
    }

    public static int max(short a, short b) {
        return a > b ? a : b;
    }

    public static int min(short a, short b, short c) {
        if (a > b) {
            a = b;
        }
        if (a > c) {
            a = c;
        }
        return a;
    }

    public static int max(short a, short b, short c) {
        if (a < b) {
            a = b;
        }
        if (a < c) {
            a = c;
        }
        return a;
    }

    public static boolean isBetween(short value, short min, short max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(long value, long min, long max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(float value, float min, float max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isZero(float value) {
        return Math.abs(value) <= 1.0E-5f;
    }

    public static boolean isZero(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-5f;
    }

    public static boolean isEqual(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static boolean isZero(double value) {
        return Math.abs(value) <= (double)1.0E-9f;
    }

    public static boolean isZero(double value, double tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) <= (double)1.0E-9f;
    }

    public static boolean isEqual(double a, double b, double tolerance) {
        return Math.abs(a - b) <= tolerance;
    }
}

