/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.ObjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public class SystemPropsUtils {
    public static final String WORKING_DIR = System.getProperty("user.dir");

    public static String getString(String key) {
        return System.getProperty(key);
    }

    public static String getString(String key, String def) {
        return System.getProperty(key, def);
    }

    public static int getInt(String key) {
        return SystemPropsUtils.getInt(key, 0);
    }

    public static int getInt(String key, int def) {
        String v = System.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static long getLong(String key) {
        return SystemPropsUtils.getLong(key, 0L);
    }

    public static long getLong(String key, long def) {
        String v = System.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static float getFloat(String key) {
        return SystemPropsUtils.getFloat(key, 0.0f);
    }

    public static float getFloat(String key, float def) {
        String v = System.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Float.parseFloat(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static double getDouble(String key) {
        return SystemPropsUtils.getDouble(key, 0.0);
    }

    public static double getDouble(String key, double def) {
        String v = System.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static boolean getBool(String key) {
        return SystemPropsUtils.getBool(key, false);
    }

    public static boolean getBool(String key, boolean def) {
        String v = System.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        return SystemPropsUtils.toBoolean(v, def);
    }

    private static boolean toBoolean(String value, boolean def) {
        if (value == null || value.isEmpty()) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return def;
        }
        return switch (value) {
            case "true", "yes", "y", "1" -> true;
            case "false", "no", "n", "0" -> false;
            default -> def;
        };
    }

    public static Properties loadPropertiesFromFile(@Nonnull String path) throws IOException {
        Objects.requireNonNull(path);
        return SystemPropsUtils.loadPropertiesFromFile(new File(path));
    }

    public static Properties loadPropertiesFromFile(@Nonnull File file) throws IOException {
        Objects.requireNonNull(file);
        if (file.exists() && file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Properties properties;
                try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);){
                    Properties properties2 = new Properties();
                    properties2.load(inputStreamReader);
                    properties = properties2;
                }
                return properties;
            }
        }
        throw new FileNotFoundException(file.getPath());
    }

    public static Properties loadPropertiesFromJar(String path) throws IOException {
        return SystemPropsUtils.loadPropertiesFromJar(path, SystemPropsUtils.class.getClassLoader());
    }

    public static Properties loadPropertiesFromJar(String path, ClassLoader classLoader) throws IOException {
        Objects.requireNonNull(path);
        URL resource = classLoader.getResource(path);
        if (resource == null) {
            throw new FileNotFoundException(path);
        }
        try (InputStream inputStream = resource.openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
    }
}

