/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.CollectionUtils;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TypeInfo {
    public final Class<?> rawType;
    public final List<TypeInfo> typeArgs;
    public static final TypeInfo OBJECT = new TypeInfo(Object.class);
    public static final TypeInfo STRING = new TypeInfo(String.class);
    public static final TypeInfo INT = new TypeInfo(Integer.TYPE);
    public static final TypeInfo LONG = new TypeInfo(Long.TYPE);
    public static final TypeInfo FLOAT = new TypeInfo(Float.TYPE);
    public static final TypeInfo DOUBLE = new TypeInfo(Double.TYPE);
    public static final TypeInfo BOOL = new TypeInfo(Boolean.TYPE);
    public static final TypeInfo SHORT = new TypeInfo(Short.TYPE);
    public static final TypeInfo BYTE = new TypeInfo(Byte.TYPE);
    public static final TypeInfo CHAR = new TypeInfo(Character.TYPE);
    public static final TypeInfo VOID = new TypeInfo(Void.TYPE);
    public static final TypeInfo BOXED_INT = new TypeInfo(Integer.class);
    public static final TypeInfo BOXED_LONG = new TypeInfo(Long.class);
    public static final TypeInfo BOXED_FLOAT = new TypeInfo(Float.class);
    public static final TypeInfo BOXED_DOUBLE = new TypeInfo(Double.class);
    public static final TypeInfo BOXED_BOOL = new TypeInfo(Boolean.class);
    public static final TypeInfo BOXED_SHORT = new TypeInfo(Short.class);
    public static final TypeInfo BOXED_BYTE = new TypeInfo(Byte.class);
    public static final TypeInfo BOXED_CHAR = new TypeInfo(Character.class);
    public static final TypeInfo BOXED_VOID = new TypeInfo(Void.class);
    public static final TypeInfo ARRAY_INT = new TypeInfo(int[].class);
    public static final TypeInfo ARRAY_LONG = new TypeInfo(long[].class);
    public static final TypeInfo ARRAY_FLOAT = new TypeInfo(float[].class);
    public static final TypeInfo ARRAY_DOUBLE = new TypeInfo(double[].class);
    public static final TypeInfo ARRAY_BOOL = new TypeInfo(boolean[].class);
    public static final TypeInfo ARRAY_SHORT = new TypeInfo(short[].class);
    public static final TypeInfo ARRAY_BYTE = new TypeInfo(byte[].class);
    public static final TypeInfo ARRAY_CHAR = new TypeInfo(char[].class);
    public static final TypeInfo ARRAY_STRING = new TypeInfo(String[].class);
    public static final TypeInfo ARRAY_OBJECT = new TypeInfo(Object[].class);
    public static final TypeInfo ARRAYLIST = new TypeInfo(ArrayList.class, OBJECT);
    public static final TypeInfo LINKED_HASHSET = new TypeInfo(LinkedHashSet.class, OBJECT);
    public static final TypeInfo HASHMAP = new TypeInfo(HashMap.class, OBJECT, OBJECT);
    public static final TypeInfo STRING_HASHMAP = new TypeInfo(HashMap.class, STRING, OBJECT);
    public static final TypeInfo LINKED_HASHMAP = new TypeInfo(LinkedHashMap.class, OBJECT, OBJECT);
    public static final TypeInfo STRING_LINKED_HASHMAP = new TypeInfo(LinkedHashMap.class, STRING, OBJECT);

    private TypeInfo(Class<?> rawType) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = List.of();
    }

    private TypeInfo(Class<?> rawType, TypeInfo typeArg1) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = List.of(typeArg1);
    }

    private TypeInfo(Class<?> rawType, TypeInfo typeArg1, TypeInfo typeArg2) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = List.of(typeArg1, typeArg2);
    }

    private TypeInfo(Class<?> rawType, List<TypeInfo> typeArgs) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = typeArgs;
    }

    public boolean isPrimitive() {
        return this.rawType.isPrimitive();
    }

    public TypeInfo box() {
        if (this.rawType == Integer.TYPE) {
            return BOXED_INT;
        }
        if (this.rawType == Long.TYPE) {
            return BOXED_LONG;
        }
        if (this.rawType == Float.TYPE) {
            return BOXED_FLOAT;
        }
        if (this.rawType == Double.TYPE) {
            return BOXED_DOUBLE;
        }
        if (this.rawType == Boolean.TYPE) {
            return BOXED_BOOL;
        }
        if (this.rawType == Byte.TYPE) {
            return BOXED_BYTE;
        }
        if (this.rawType == Short.TYPE) {
            return BOXED_SHORT;
        }
        if (this.rawType == Character.TYPE) {
            return BOXED_CHAR;
        }
        if (this.rawType == Void.TYPE) {
            return BOXED_VOID;
        }
        throw new RuntimeException();
    }

    public boolean isEnum() {
        return this.rawType.isEnum();
    }

    public boolean hasTypeArgs() {
        return this.typeArgs.size() > 0;
    }

    public boolean isGenericType() {
        if (this.rawType.isPrimitive() || this.rawType.isArray()) {
            return false;
        }
        return this.typeArgs.size() > 0 || this.rawType.getTypeParameters().length > 0;
    }

    public boolean isConstructedGenericType() {
        if (this.rawType.isPrimitive() || this.rawType.isArray()) {
            return false;
        }
        return this.typeArgs.size() > 0;
    }

    public TypeInfo getTypeArg(int idx) {
        return this.typeArgs.get(idx);
    }

    public boolean isArrayType() {
        return this.rawType.isArray();
    }

    public int getArrayRank() {
        int r = 0;
        Class<?> clazz = this.rawType;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++r;
        }
        return r;
    }

    public boolean isConstructedGenericArrayType() {
        return this.rawType.isArray() && this.typeArgs.size() > 0;
    }

    public TypeInfo getComponentType() {
        if (this.rawType.isArray()) {
            return new TypeInfo(this.rawType.getComponentType(), this.typeArgs);
        }
        throw new IllegalStateException("This operation is only valid on array types");
    }

    public TypeInfo getRootComponentType() {
        if (this.rawType.isArray()) {
            Class<?> root = ArrayUtils.getRootComponentType(this.rawType);
            return new TypeInfo(root, this.typeArgs);
        }
        throw new IllegalStateException("This operation is only valid on array types");
    }

    public TypeInfo makeArrayType() {
        return new TypeInfo((Class<?>)this.rawType.arrayType(), this.typeArgs);
    }

    public TypeInfo makeArrayType(int rank) {
        TypeDescriptor.OfField<Class<?>> rawType = this.rawType;
        while (rank-- > 0) {
            rawType = rawType.arrayType();
        }
        return new TypeInfo((Class<?>)rawType, this.typeArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.equals((TypeInfo)o);
    }

    public boolean equals(TypeInfo that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (this.rawType != that.rawType) {
            return false;
        }
        if (this.typeArgs.isEmpty() && that.typeArgs.isEmpty()) {
            return true;
        }
        return CollectionUtils.sequenceEqual(this.typeArgs, that.typeArgs);
    }

    public int hashCode() {
        int result = this.rawType.hashCode();
        for (int i = 0; i < this.typeArgs.size(); ++i) {
            result = 31 * result + this.typeArgs.get(i).hashCode();
        }
        return result;
    }

    public String toString() {
        return "TypeInfo{rawType=" + String.valueOf(this.rawType) + ", typeArgs=" + String.valueOf(this.typeArgs) + "}";
    }

    public static TypeInfo of(Class<?> rawType) {
        if (rawType == Integer.class) {
            return BOXED_INT;
        }
        if (rawType == Long.class) {
            return BOXED_LONG;
        }
        if (rawType == String.class) {
            return STRING;
        }
        if (rawType == Object.class) {
            return OBJECT;
        }
        return new TypeInfo(rawType);
    }

    public static TypeInfo of(Class<?> rawType, TypeInfo typeArg1) {
        return new TypeInfo(rawType, typeArg1);
    }

    public static TypeInfo of(Class<?> rawType, TypeInfo typeArg1, TypeInfo typeArg2) {
        return new TypeInfo(rawType, typeArg1, typeArg2);
    }

    public static TypeInfo of(Class<?> rawType, TypeInfo ... typeArgs) {
        return new TypeInfo(rawType, List.of(typeArgs));
    }

    public static TypeInfo of(Class<?> rawType, List<TypeInfo> typeArgs) {
        return new TypeInfo(rawType, List.copyOf(typeArgs));
    }

    public static TypeInfo of(Class<?> rawType, List<TypeInfo> typeArgs, TypeInfo typeArg1) {
        TypeInfo[] newTypeInfo = new TypeInfo[typeArgs.size() + 2];
        typeArgs.toArray(newTypeInfo);
        newTypeInfo[typeArgs.size()] = Objects.requireNonNull(typeArg1);
        return new TypeInfo(rawType, List.of(newTypeInfo));
    }

    public static TypeInfo of(Class<?> rawType, List<TypeInfo> typeArgs, TypeInfo typeArg1, TypeInfo typeArg2) {
        TypeInfo[] newTypeInfo = new TypeInfo[typeArgs.size() + 2];
        typeArgs.toArray(newTypeInfo);
        newTypeInfo[typeArgs.size()] = Objects.requireNonNull(typeArg1);
        newTypeInfo[typeArgs.size() + 1] = Objects.requireNonNull(typeArg2);
        return new TypeInfo(rawType, List.of(newTypeInfo));
    }

    public static TypeInfo of(Class<?> rawType, Class<?> typeArg1) {
        return new TypeInfo(rawType, TypeInfo.of(typeArg1));
    }

    public static TypeInfo of(Class<?> rawType, Class<?> typeArg1, Class<?> typeArg2) {
        return new TypeInfo(rawType, TypeInfo.of(typeArg1), TypeInfo.of(typeArg2));
    }

    public static TypeInfo of(Class<?> rawType, Class<?> ... typeArgs) {
        TypeInfo[] typeInfos = new TypeInfo[typeArgs.length];
        for (int i = 0; i < typeArgs.length; ++i) {
            typeInfos[i] = TypeInfo.of(typeArgs[i]);
        }
        return new TypeInfo(rawType, List.of(typeInfos));
    }
}

