/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.mutable.MutableInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TypeName {
    public final String name;
    public final List<TypeName> typeArgs;
    private int _hashcode;

    public TypeName(String name) {
        this.name = name;
        this.typeArgs = List.of();
    }

    public TypeName(String name, List<TypeName> typeArgs) {
        this.name = Objects.requireNonNull(name, "clsName");
        this.typeArgs = typeArgs == null ? List.of() : List.copyOf(typeArgs);
    }

    public boolean isArray() {
        int idx = this.name.length() - 1;
        return this.name.charAt(idx) == ']' && this.name.charAt(idx - 1) == '[';
    }

    public int getArrayRank() {
        int r = 0;
        int idx = this.name.length() - 1;
        while (this.name.charAt(idx) == ']' && this.name.charAt(idx - 1) == '[') {
            idx -= 2;
            ++r;
        }
        return r;
    }

    public String getRootElement() {
        int idx = this.name.length() - 1;
        while (this.name.charAt(idx) == ']' && this.name.charAt(idx - 1) == '[') {
            idx -= 2;
        }
        return this.name.substring(0, idx + 1);
    }

    public boolean isGeneric() {
        int idx = this.name.length() - 1;
        return this.name.charAt(idx) != ']' && this.typeArgs.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeName other = (TypeName)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.typeArgs.isEmpty() && other.typeArgs.isEmpty()) {
            return true;
        }
        return CollectionUtils.sequenceEqual(this.typeArgs, other.typeArgs);
    }

    public int hashCode() {
        int r = this._hashcode;
        if (r == 0) {
            this._hashcode = r = this.name.hashCode() * 31 + CollectionUtils.hashcode(this.typeArgs);
        }
        return r;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        int arrayRank;
        if (sb == null) {
            sb = new StringBuilder(this.name.length());
        }
        if ((arrayRank = this.getArrayRank()) == 0) {
            sb.append(this.name);
        } else {
            sb.append(this.name, 0, this.name.length() - arrayRank * 2);
        }
        if (this.typeArgs.size() > 0) {
            sb.append('[');
            for (int i = 0; i < this.typeArgs.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                this.typeArgs.get(i).toString(sb);
            }
            sb.append(']');
        }
        if (arrayRank > 0) {
            sb.append(ArrayUtils.arrayRankSymbol(arrayRank));
        }
        return sb;
    }

    public static TypeName parse(String fullClsName) {
        return TypeName.parse(fullClsName, 0, fullClsName.length() - 1);
    }

    private static TypeName parse(String fullClsName, int rawStartIndex, int rawEndIndex) {
        rawStartIndex = TypeName.skipLeading(fullClsName, rawStartIndex);
        rawEndIndex = TypeName.skipTrailing(fullClsName, rawEndIndex);
        int arrayRank = 0;
        while (fullClsName.charAt(rawEndIndex) == ']' && fullClsName.charAt(rawEndIndex - 1) == '[') {
            rawEndIndex -= 2;
            ++arrayRank;
        }
        int typeArgStartIdx = fullClsName.indexOf(91, rawStartIndex, rawEndIndex + 1);
        if (typeArgStartIdx > 0) {
            String typeArg;
            int typeArgEndIdx = fullClsName.lastIndexOf(93, rawEndIndex);
            if (typeArgEndIdx < 0 || typeArgStartIdx + 1 >= typeArgEndIdx) {
                throw new IllegalArgumentException("bad fullClsName : " + fullClsName);
            }
            int clsNameEndIndex = typeArgStartIdx - 1;
            clsNameEndIndex = TypeName.skipTrailing(fullClsName, clsNameEndIndex);
            Object clsName = fullClsName.substring(rawStartIndex, clsNameEndIndex + 1);
            if (arrayRank > 0) {
                clsName = (String)clsName + ArrayUtils.arrayRankSymbol(arrayRank);
            }
            ArrayList<TypeName> typeArgs = new ArrayList<TypeName>(2);
            MutableInt eleStartIdx = new MutableInt(typeArgStartIdx + 1);
            while (eleStartIdx.getValue() > 0 && (typeArg = TypeName.scanNextTypeArg(fullClsName, eleStartIdx.getValue(), typeArgEndIdx - 1, eleStartIdx)) != null) {
                if (typeArg.indexOf(91) > 0) {
                    typeArgs.add(TypeName.parse(typeArg, 0, typeArg.length() - 1));
                    continue;
                }
                typeArgs.add(new TypeName(typeArg, null));
            }
            return new TypeName((String)clsName, typeArgs);
        }
        return new TypeName(fullClsName, null);
    }

    private static String scanNextTypeArg(String typeArgs, int startIndex, int endIndex, MutableInt nextStartIndex) {
        if ((startIndex = TypeName.skipLeading(typeArgs, startIndex)) > (endIndex = TypeName.skipTrailing(typeArgs, endIndex))) {
            nextStartIndex.setValue(-1);
            return null;
        }
        int stackDepth = 0;
        for (int index = startIndex; index <= endIndex; ++index) {
            char c = typeArgs.charAt(index);
            if (c == ',' && stackDepth == 0) {
                nextStartIndex.setValue(index + 1);
                index = TypeName.skipTrailing(typeArgs, index - 1);
                return typeArgs.substring(startIndex, index + 1);
            }
            if (c == '[') {
                ++stackDepth;
            } else if (c == ']') {
                --stackDepth;
            }
            if (index != endIndex) continue;
            assert (stackDepth == 0);
            nextStartIndex.setValue(-1);
            index = TypeName.skipTrailing(typeArgs, index);
            return typeArgs.substring(startIndex, index + 1);
        }
        throw new IllegalArgumentException("bad typeArgs: " + typeArgs);
    }

    private static int skipLeading(String str, int index) {
        while (Character.isWhitespace(str.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int skipTrailing(String str, int index) {
        while (Character.isWhitespace(str.charAt(index))) {
            --index;
        }
        return index;
    }
}

