/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

final class DynamicArrayHelper {
    private static final long WORD_MASK = -1L;
    private static final int ADDRESS_BITS_PER_WORD = 6;

    DynamicArrayHelper() {
    }

    public static int wordIndex(int index) {
        return index >> 6;
    }

    public static int wordCount(int bitCount) {
        return (bitCount >> 6) + 1;
    }

    public static boolean isCompressionNeeded(float nullFactor, int len, int elementCount) {
        if (nullFactor == 0.0f) {
            return true;
        }
        if (nullFactor > 1.0f) {
            return false;
        }
        int nullCount = len - elementCount;
        if (nullFactor == 1.0f) {
            return nullCount == len;
        }
        return nullCount >= 4 && (float)nullCount >= (float)len * nullFactor;
    }

    public static int firstNullIndex(long[] elementsMask, int len, int elementCount) {
        if (elementCount == len) {
            return -1;
        }
        int wordCount = DynamicArrayHelper.wordCount(len);
        for (int idx = 0; idx < wordCount; ++idx) {
            long word = elementsMask[idx];
            if (word == -1L) continue;
            return idx * 64 + Long.numberOfTrailingZeros(word ^ 0xFFFFFFFFFFFFFFFFL);
        }
        throw new AssertionError();
    }

    public static int lastNullIndex(long[] elementsMask, int len, int elementCount) {
        if (elementCount == len) {
            return -1;
        }
        int wordCount = DynamicArrayHelper.wordCount(len);
        for (int idx = wordCount - 1; idx >= 0; --idx) {
            long word = elementsMask[idx];
            if (idx == wordCount - 1 && (len & 0x3F) != 0) {
                word |= -1L << len;
            }
            if (word == -1L) continue;
            return idx * 64 + (63 - Long.numberOfLeadingZeros(word ^ 0xFFFFFFFFFFFFFFFFL));
        }
        throw new AssertionError();
    }

    public static long insertBit(long word, int bitIndex) {
        int index = bitIndex & 0x3F;
        long high = word << 1 & -1L << index + 1;
        long lower = word & (1L << index) - 1L;
        return high | lower;
    }

    public static void insertBit(long[] elementsMask, int len, int bitIndex) {
        int wordIndex = DynamicArrayHelper.wordIndex(bitIndex);
        for (int idx = DynamicArrayHelper.wordCount(len) - 1; idx > wordIndex; --idx) {
            elementsMask[idx] = elementsMask[idx] << 1;
        }
        long word = elementsMask[wordIndex];
        int index = bitIndex & 0x3F;
        long high = word << 1 & -1L << index + 1;
        long lower = word & (1L << index) - 1L;
        elementsMask[wordIndex] = high | lower;
    }

    public static void setBit(long[] elementsMask, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = DynamicArrayHelper.wordIndex(fromIndex);
        int endWordIndex = DynamicArrayHelper.wordIndex(toIndex - 1);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            elementsMask[n] = elementsMask[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            elementsMask[n] = elementsMask[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                elementsMask[i] = -1L;
            }
            int n2 = endWordIndex;
            elementsMask[n2] = elementsMask[n2] | lastWordMask;
        }
    }

    public static void clearBit(long[] elementsMask, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = DynamicArrayHelper.wordIndex(fromIndex);
        int endWordIndex = DynamicArrayHelper.wordIndex(toIndex - 1);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            elementsMask[n] = elementsMask[n] & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n = startWordIndex;
            elementsMask[n] = elementsMask[n] & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                elementsMask[i] = 0L;
            }
            int n2 = endWordIndex;
            elementsMask[n2] = elementsMask[n2] & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

