/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.MathCommon;
import cn.wjybxx.base.collection.DynamicArray;
import cn.wjybxx.base.collection.DynamicArrayHelper;
import cn.wjybxx.base.collection.IndexedElementHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IndexedDynamicArray<E>
implements DynamicArray<E> {
    private static final int MAX_CAPACITY = 0x7FFFFFF7;
    private final IndexedElementHelper<? super E> helper;
    private Object[] elements;
    private long[] elementsMask;
    private final float nullFactor;
    private int len;
    private int elementCount;
    private int recursionDepth;

    public IndexedDynamicArray(IndexedElementHelper<? super E> helper, int initCapacity) {
        this(helper, initCapacity, 0.125f);
    }

    public IndexedDynamicArray(IndexedElementHelper<? super E> helper, int initCapacity, float nullFactor) {
        this.helper = Objects.requireNonNull(helper, "helper");
        this.elements = new Object[initCapacity];
        this.elementsMask = new long[DynamicArrayHelper.wordCount(initCapacity)];
        this.nullFactor = Math.max(0.0f, nullFactor);
    }

    @Override
    public boolean isIterating() {
        return this.recursionDepth > 0;
    }

    @Override
    public void beginItr() {
        ++this.recursionDepth;
    }

    @Override
    public void endItr() {
        if (this.recursionDepth == 0) {
            throw new IllegalStateException("begin must be called before end.");
        }
        --this.recursionDepth;
        if (this.recursionDepth == 0 && this.isCompressionNeeded()) {
            this.removeNullElements();
        }
    }

    @Override
    @Nullable
    public E get(int index) {
        Objects.checkIndex(index, this.len);
        return (E)this.elements[index];
    }

    @Override
    public E set(int index, @Nullable E e) {
        Objects.checkIndex(index, this.len);
        Object prev = this.elements[index];
        if (prev != null) {
            this.helper.collectionIndex(this, prev, -1);
            --this.elementCount;
        }
        if (e != null) {
            this.helper.collectionIndex(this, e, index);
            ++this.elementCount;
        }
        this.setBit(index, e != null);
        this.elements[index] = e;
        if (e == null && this.recursionDepth == 0 && this.isCompressionNeeded()) {
            this.removeNullElements();
        }
        return (E)prev;
    }

    @Override
    public void add(E e) {
        this.requireNonNullAndNotContains(e);
        if (this.len == this.elements.length) {
            this.ensureCapacity(this.len + 1);
        }
        this.helper.collectionIndex(this, e, this.len);
        ++this.elementCount;
        this.setBit(this.len, true);
        this.elements[this.len++] = e;
    }

    @Override
    public void insert(int index, E e) {
        this.requireNonNullAndNotContains(e);
        Objects.checkIndex(index, this.len);
        this.ensureNotIterating();
        if (this.len == this.elements.length) {
            this.ensureCapacity(this.len + 1);
        }
        if (index < this.len) {
            System.arraycopy(this.elements, index, this.elements, index + 1, this.len - index);
            this.insertBit(index);
        }
        this.helper.collectionIndex(this, e, index);
        ++this.elementCount;
        this.setBit(index, true);
        this.elements[index] = e;
        ++this.len;
    }

    @Override
    public boolean remove(E e) {
        if (e == null) {
            return false;
        }
        int i = this.indexOf(e);
        if (i >= 0) {
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRef(E e) {
        if (e == null) {
            return false;
        }
        int i = this.indexOfRef(e);
        if (i >= 0) {
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        int idx;
        if (this.elementCount == 0) {
            return;
        }
        int len = this.len;
        for (idx = 0; idx < len; ++idx) {
            Object e = this.elements[idx];
            if (e == null) continue;
            this.helper.collectionIndex(this, e, -1);
            this.elements[idx] = null;
        }
        int wordCount = DynamicArrayHelper.wordCount(this.len);
        for (idx = 0; idx < wordCount; ++idx) {
            this.elementsMask[idx] = 0L;
        }
        this.elementCount = 0;
        if (this.recursionDepth == 0) {
            this.len = 0;
        }
    }

    private void requireNonNullAndNotContains(E e) {
        if (e == null) {
            throw new NullPointerException("e");
        }
        if (this.helper.collectionIndex(this, e) != -1) {
            throw new IllegalArgumentException("e.queueIndex(): %d (expected: %d) + e: %s".formatted(this.helper.collectionIndex(this, e), -1, e));
        }
    }

    @Override
    public boolean contains(E e) {
        return this.indexOf(e) >= 0;
    }

    @Override
    public boolean containsRef(E e) {
        return this.indexOfRef(e) >= 0;
    }

    @Override
    public int indexOf(@Nullable E e) {
        if (e == null) {
            return this.firstNullIndex();
        }
        return this.helper.collectionIndex(this, e);
    }

    @Override
    public int lastIndexOf(@Nullable E e) {
        if (e == null) {
            return this.lastNullIndex();
        }
        return this.helper.collectionIndex(this, e);
    }

    @Override
    public int indexOfRef(@Nullable E e) {
        if (e == null) {
            return this.firstNullIndex();
        }
        return this.helper.collectionIndex(this, e);
    }

    @Override
    public int lastIndexOfRef(@Nullable E e) {
        if (e == null) {
            return this.lastNullIndex();
        }
        return this.helper.collectionIndex(this, e);
    }

    private int firstNullIndex() {
        return DynamicArrayHelper.firstNullIndex(this.elementsMask, this.len, this.elementCount);
    }

    private int lastNullIndex() {
        return DynamicArrayHelper.lastNullIndex(this.elementsMask, this.len, this.elementCount);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public int elementCount() {
        return this.elementCount;
    }

    @Override
    public int nullCount() {
        return this.len - this.elementCount;
    }

    @Override
    public boolean containsNull() {
        return this.elementCount < this.len;
    }

    @Override
    public void sort(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        this.ensureNotIterating();
        if (this.containsNull()) {
            this.removeNullElements();
        }
        Object[] elements = this.elements;
        Arrays.sort(elements, 0, this.len, comparator);
        this.batchUpdateIndex(elements, 0, this.len);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (minCapacity <= oldCapacity) {
            return;
        }
        if (minCapacity > 0x7FFFFFF7) {
            throw new OutOfMemoryError("Required array length " + minCapacity + " is too large");
        }
        int grow = Math.max(16, oldCapacity >> 1);
        int newCapacity = MathCommon.clamp((long)oldCapacity + (long)grow, minCapacity, 0x7FFFFFF7);
        this.elements = Arrays.copyOf(this.elements, newCapacity);
        if (DynamicArrayHelper.wordCount(oldCapacity) < DynamicArrayHelper.wordCount(newCapacity)) {
            this.elementsMask = Arrays.copyOf(this.elementsMask, DynamicArrayHelper.wordCount(newCapacity));
        }
    }

    @Override
    public void compress(boolean force) {
        this.ensureNotIterating();
        if (force || this.isCompressionNeeded()) {
            this.removeNullElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(ObjIntConsumer<? super E> action) {
        Objects.requireNonNull(action);
        int size = this.len;
        if (size == 0) {
            return;
        }
        this.beginItr();
        try {
            Object[] elements = this.elements;
            for (int index = 0; index < size; ++index) {
                Object e = elements[index];
                if (e == null) continue;
                action.accept(e, index);
            }
        }
        finally {
            this.endItr();
        }
    }

    @Override
    public List<E> toList() {
        ArrayList<Object> result = new ArrayList<Object>(this.elementCount);
        Object[] elements = this.elements;
        int end = this.len;
        for (int i = 0; i < end; ++i) {
            Object e = elements[i];
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    private void setBit(int index, boolean val) {
        if (val) {
            int n = DynamicArrayHelper.wordIndex(index);
            this.elementsMask[n] = this.elementsMask[n] | 1L << index;
        } else {
            int n = DynamicArrayHelper.wordIndex(index);
            this.elementsMask[n] = this.elementsMask[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private void insertBit(int bitIndex) {
        DynamicArrayHelper.insertBit(this.elementsMask, this.len, bitIndex);
    }

    private void ensureNotIterating() {
        if (this.recursionDepth != 0) {
            throw new IllegalStateException("Invalid between iterating.");
        }
    }

    private boolean isCompressionNeeded() {
        return DynamicArrayHelper.isCompressionNeeded(this.nullFactor, this.len, this.elementCount);
    }

    private void removeNullElements() {
        assert (this.recursionDepth == 0);
        int elementCount = this.elementCount;
        if (elementCount == this.len) {
            return;
        }
        if (elementCount == 0) {
            this.len = 0;
            return;
        }
        int firstNullIndex = this.firstNullIndex();
        int lastNullIndex = this.lastNullIndex();
        Object[] elements = this.elements;
        IndexedElementHelper<Object> helper = this.helper;
        for (int index = firstNullIndex + 1; index < lastNullIndex; ++index) {
            Object element = elements[index];
            if (element == null) continue;
            Object castE = element;
            helper.collectionIndex(this, castE, firstNullIndex);
            this.setBit(firstNullIndex, true);
            elements[firstNullIndex++] = element;
        }
        int copyStart = lastNullIndex + 1;
        if (copyStart < this.len) {
            System.arraycopy(elements, copyStart, elements, firstNullIndex, this.len - copyStart);
        }
        this.batchUpdateIndex(elements, firstNullIndex, elementCount);
        DynamicArrayHelper.setBit(this.elementsMask, firstNullIndex, elementCount);
        DynamicArrayHelper.clearBit(this.elementsMask, elementCount, this.len);
        Arrays.fill(elements, elementCount, this.len, null);
        this.len = elementCount;
    }

    private void batchUpdateIndex(Object[] elements, int start, int end) {
        IndexedElementHelper<Object> helper = this.helper;
        for (int index = start; index < end; ++index) {
            Object castE = elements[index];
            helper.collectionIndex(this, castE, index);
        }
    }
}

