/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.MathCommon;
import cn.wjybxx.base.collection.DynamicArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SmallDynamicArray<E>
implements DynamicArray<E> {
    private static final int MAX_CAPACITY = 64;
    private Object[] elements;
    private long elementsMask;
    private final float nullFactor;
    private int len;
    private int recursionDepth;

    public SmallDynamicArray(int initCapacity) {
        this(initCapacity, 0.25f);
    }

    public SmallDynamicArray(int initCapacity, float nullFactor) {
        if (initCapacity > 64) {
            throw new IllegalArgumentException("initCapacity: " + initCapacity);
        }
        this.elements = initCapacity == 0 ? ArrayUtils.EMPTY_OBJECT_ARRAY : new Object[initCapacity];
        this.nullFactor = Math.max(0.0f, nullFactor);
    }

    @Override
    public boolean isIterating() {
        return this.recursionDepth > 0;
    }

    @Override
    public void beginItr() {
        ++this.recursionDepth;
    }

    @Override
    public void endItr() {
        if (this.recursionDepth == 0) {
            throw new IllegalStateException("begin must be called before end.");
        }
        --this.recursionDepth;
        if (this.recursionDepth == 0 && this.isCompressionNeeded()) {
            this.removeNullElements();
        }
    }

    @Override
    @Nullable
    public E get(int index) {
        Objects.checkIndex(index, this.len);
        return (E)this.elements[index];
    }

    @Override
    public E set(int index, @Nullable E e) {
        Objects.checkIndex(index, this.len);
        Object prev = this.elements[index];
        this.setBit(index, e != null);
        this.elements[index] = e;
        if (e == null && this.recursionDepth == 0 && this.isCompressionNeeded()) {
            this.removeNullElements();
        }
        return (E)prev;
    }

    @Override
    public void add(E e) {
        Objects.requireNonNull(e);
        if (this.len == this.elements.length) {
            this.ensureCapacity(this.len + 1);
        }
        this.setBit(this.len, true);
        this.elements[this.len++] = e;
    }

    @Override
    public void insert(int index, E e) {
        Objects.requireNonNull(e);
        Objects.checkIndex(index, this.len);
        this.ensureNotIterating();
        if (this.len == this.elements.length) {
            this.ensureCapacity(this.len + 1);
        }
        if (index < this.len) {
            System.arraycopy(this.elements, index, this.elements, index + 1, this.len - index);
            this.insertBit(index);
        }
        this.setBit(index, true);
        this.elements[index] = e;
        ++this.len;
    }

    @Override
    public boolean remove(E e) {
        if (e == null) {
            return false;
        }
        int i = this.indexOf(e);
        if (i >= 0) {
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRef(E e) {
        if (e == null) {
            return false;
        }
        int i = this.indexOfRef(e);
        if (i >= 0) {
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.elementsMask == 0L) {
            return;
        }
        Arrays.fill(this.elements, 0, this.len, null);
        this.elementsMask = 0L;
        if (this.recursionDepth == 0) {
            this.len = 0;
        }
    }

    @Override
    public boolean contains(E e) {
        return this.indexOf(e) >= 0;
    }

    @Override
    public boolean containsRef(E e) {
        return this.indexOfRef(e) >= 0;
    }

    @Override
    public int indexOf(@Nullable E e) {
        if (e == null) {
            return this.firstNullIndex();
        }
        return ArrayUtils.indexOf(this.elements, e, 0, this.len);
    }

    @Override
    public int lastIndexOf(@Nullable E e) {
        if (e == null) {
            return this.lastNullIndex();
        }
        return ArrayUtils.lastIndexOf(this.elements, e, 0, this.len);
    }

    @Override
    public int indexOfRef(@Nullable E e) {
        if (e == null) {
            return this.firstNullIndex();
        }
        return ArrayUtils.indexOfRef(this.elements, e, 0, this.len);
    }

    @Override
    public int lastIndexOfRef(@Nullable E e) {
        if (e == null) {
            return this.lastNullIndex();
        }
        return ArrayUtils.lastIndexOfRef(this.elements, e, 0, this.len);
    }

    private int firstNullIndex() {
        if (this.len == 0) {
            return -1;
        }
        return Long.numberOfTrailingZeros(this.elementsMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private int lastNullIndex() {
        if (this.len == 0) {
            return -1;
        }
        long tempMask = this.len == 64 ? this.elementsMask : this.elementsMask | -1L << this.len;
        return 63 - Long.numberOfLeadingZeros(tempMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public int elementCount() {
        return MathCommon.bitCount(this.elementsMask);
    }

    @Override
    public int nullCount() {
        return this.len - MathCommon.bitCount(this.elementsMask);
    }

    @Override
    public boolean containsNull() {
        return this.len > 0 && this.elementsMask == 0L;
    }

    @Override
    public void sort(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        this.ensureNotIterating();
        if (this.containsNull()) {
            this.removeNullElements();
        }
        Object[] elements = this.elements;
        Arrays.sort(elements, 0, this.len, comparator);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (minCapacity > 64) {
            throw new IllegalStateException("overflow");
        }
        int oldCapacity = this.elements.length;
        if (minCapacity <= oldCapacity) {
            return;
        }
        int grow = oldCapacity < 16 ? 4 : (oldCapacity < 32 ? 8 : 16);
        int newCapacity = MathCommon.clamp(oldCapacity + grow, minCapacity, 64);
        this.elements = Arrays.copyOf(this.elements, newCapacity);
    }

    @Override
    public void compress(boolean ignoreFactor) {
        this.ensureNotIterating();
        if (ignoreFactor || this.isCompressionNeeded()) {
            this.removeNullElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(ObjIntConsumer<? super E> action) {
        Objects.requireNonNull(action);
        int len = this.len;
        if (len == 0) {
            return;
        }
        this.beginItr();
        try {
            Object[] elements = this.elements;
            for (int index = 0; index < len; ++index) {
                Object e = elements[index];
                if (e == null) continue;
                action.accept(e, index);
            }
        }
        finally {
            this.endItr();
        }
    }

    @Override
    public List<E> toList() {
        ArrayList<Object> result = new ArrayList<Object>(this.elementCount());
        Object[] elements = this.elements;
        int end = this.len;
        for (int i = 0; i < end; ++i) {
            Object e = elements[i];
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    private void setBit(int index, boolean val) {
        this.elementsMask = val ? (this.elementsMask |= 1L << index) : (this.elementsMask &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void insertBit(int index) {
        long high = this.elementsMask << 1 & -1L << index + 1;
        long lower = this.elementsMask & (1L << index) - 1L;
        this.elementsMask = high | lower;
    }

    private void ensureNotIterating() {
        if (this.recursionDepth != 0) {
            throw new IllegalStateException("Invalid between iterating.");
        }
    }

    private boolean isCompressionNeeded() {
        float nullFactor = this.nullFactor;
        if (nullFactor == 0.0f) {
            return true;
        }
        if (nullFactor > 1.0f) {
            return false;
        }
        int nullCount = this.len - this.elementCount();
        if (nullFactor == 1.0f) {
            return nullCount == this.len;
        }
        return nullCount >= 4 && (float)nullCount >= (float)this.len * nullFactor;
    }

    private void removeNullElements() {
        assert (this.recursionDepth == 0);
        int elementCount = this.elementCount();
        if (elementCount == this.len) {
            return;
        }
        if (elementCount == 0) {
            this.len = 0;
            this.elementsMask = 0L;
            return;
        }
        int firstNullIndex = this.firstNullIndex();
        int lastNullIndex = this.lastNullIndex();
        Object[] elements = this.elements;
        for (int index = firstNullIndex + 1; index < lastNullIndex; ++index) {
            Object element = elements[index];
            if (element == null) continue;
            elements[index] = null;
            elements[firstNullIndex++] = element;
        }
        int copyStart = lastNullIndex + 1;
        if (copyStart < this.len) {
            System.arraycopy(elements, copyStart, elements, firstNullIndex, this.len - copyStart);
        }
        Arrays.fill(elements, elementCount, this.len, null);
        this.len = elementCount;
        this.elementsMask = (1L << elementCount) - 1L;
    }
}

