/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.concurrent;

import cn.wjybxx.base.concurrent.ICancelToken;
import cn.wjybxx.base.concurrent.IContext;
import cn.wjybxx.base.concurrent.ITask;
import cn.wjybxx.base.concurrent.SingleThreadExecutor;
import cn.wjybxx.base.concurrent.TaskOptions;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ExecutorCoreUtils {
    public static boolean inEventLoop(@Nullable Executor executor) {
        SingleThreadExecutor eventLoop;
        return executor instanceof SingleThreadExecutor && (eventLoop = (SingleThreadExecutor)executor).inEventLoop();
    }

    public static ICancelToken getCancelToken(Object ctx, int options) {
        if (ctx == null || TaskOptions.isEnabled(options, 0x1000000)) {
            return ICancelToken.NONE;
        }
        if (ctx instanceof ICancelToken) {
            ICancelToken cancelToken = (ICancelToken)ctx;
            return cancelToken;
        }
        if (ctx instanceof IContext) {
            IContext ctx2 = (IContext)ctx;
            return ctx2.cancelToken();
        }
        return ICancelToken.NONE;
    }

    public static boolean isCancelRequested(Object ctx, int options) {
        if (ctx == null || TaskOptions.isEnabled(options, 0x1000000)) {
            return false;
        }
        if (ctx instanceof ICancelToken) {
            ICancelToken cancelToken = (ICancelToken)ctx;
            return cancelToken.isCancelRequested();
        }
        if (ctx instanceof IContext) {
            IContext ctx2 = (IContext)ctx;
            return ctx2.cancelToken().isCancelRequested();
        }
        return false;
    }

    public static boolean isInlinable(@Nullable Executor e, int options) {
        SingleThreadExecutor eventLoop;
        if (e == null) {
            return true;
        }
        return TaskOptions.isEnabled(options, 0x800000) && e instanceof SingleThreadExecutor && (eventLoop = (SingleThreadExecutor)e).inEventLoop();
    }

    public static ITask toTask(Runnable action, int options) {
        Objects.requireNonNull(action, "action");
        return new Task1(action, options);
    }

    public static ITask toTask(Runnable action, ICancelToken cancelToken, int options) {
        Objects.requireNonNull(action, "action");
        return new Task2(action, cancelToken, options);
    }

    public static ITask toTask(Consumer<Object> action, Object ctx, int options) {
        Objects.requireNonNull(action, "action");
        return new Task3(action, ctx, options);
    }

    private static class Task1
    implements ITask {
        private Runnable action;
        private final int options;

        public Task1(Runnable action, int options) {
            this.action = action;
            this.options = options;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public void run() {
            Runnable action = this.action;
            this.action = null;
            action.run();
        }
    }

    private static class Task2
    implements ITask {
        private Runnable action;
        private ICancelToken cancelToken;
        private final int options;

        public Task2(Runnable action, ICancelToken cancelToken, int options) {
            this.action = action;
            this.cancelToken = cancelToken;
            this.options = options;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public void run() {
            Runnable action = this.action;
            ICancelToken cancelToken = this.cancelToken;
            this.action = null;
            this.cancelToken = null;
            if (cancelToken != null && cancelToken.isCancelRequested()) {
                return;
            }
            action.run();
        }
    }

    private static class Task3
    implements ITask {
        private Consumer<Object> action;
        private Object ctx;
        private final int options;

        public Task3(Consumer<Object> action, Object ctx, int options) {
            this.action = action;
            this.ctx = ctx;
            this.options = options;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public void run() {
            Consumer<Object> action = this.action;
            Object ctx = this.ctx;
            this.action = null;
            this.ctx = null;
            if (ExecutorCoreUtils.isCancelRequested(ctx, this.options)) {
                return;
            }
            action.accept(ctx);
        }
    }
}

