/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.concurrent;

import cn.wjybxx.base.IRegistration;
import cn.wjybxx.base.concurrent.BetterCancellationException;
import cn.wjybxx.base.concurrent.CancelCodes;
import cn.wjybxx.base.concurrent.ICancelTokenListener;
import cn.wjybxx.base.concurrent.ICancelTokenSource;
import cn.wjybxx.base.concurrent.UncancellableToken;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface ICancelToken {
    public static final ICancelToken NONE = UncancellableToken.INST;

    public boolean canBeCancelled();

    public int cancelCode();

    default public boolean isCancelRequested() {
        return this.cancelCode() != 0;
    }

    default public int reason() {
        return CancelCodes.getReason(this.cancelCode());
    }

    default public void checkCancel() {
        int code = this.cancelCode();
        if (code != 0) {
            throw new BetterCancellationException(code);
        }
    }

    public IRegistration thenAccept(Consumer<? super ICancelToken> var1, int var2);

    public IRegistration thenAccept(Consumer<? super ICancelToken> var1);

    public IRegistration thenAcceptAsync(Executor var1, Consumer<? super ICancelToken> var2);

    public IRegistration thenAcceptAsync(Executor var1, Consumer<? super ICancelToken> var2, int var3);

    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> var1, Object var2, int var3);

    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> var1, Object var2);

    public IRegistration thenAcceptAsync(Executor var1, BiConsumer<? super ICancelToken, Object> var2, Object var3);

    public IRegistration thenAcceptAsync(Executor var1, BiConsumer<? super ICancelToken, Object> var2, Object var3, int var4);

    public IRegistration thenRun(Runnable var1, int var2);

    public IRegistration thenRun(Runnable var1);

    public IRegistration thenRunAsync(Executor var1, Runnable var2);

    public IRegistration thenRunAsync(Executor var1, Runnable var2, int var3);

    public IRegistration thenRun(Consumer<Object> var1, Object var2, int var3);

    public IRegistration thenRun(Consumer<Object> var1, Object var2);

    public IRegistration thenRunAsync(Executor var1, Consumer<Object> var2, Object var3);

    public IRegistration thenRunAsync(Executor var1, Consumer<Object> var2, Object var3, int var4);

    public IRegistration thenNotify(ICancelTokenListener var1, Object var2, int var3);

    public IRegistration thenNotify(ICancelTokenListener var1, Object var2);

    public IRegistration thenNotifyAsync(Executor var1, ICancelTokenListener var2, Object var3);

    public IRegistration thenNotifyAsync(Executor var1, ICancelTokenListener var2, Object var3, int var4);

    public IRegistration thenTransferTo(ICancelTokenSource var1, int var2);

    public IRegistration thenTransferTo(ICancelTokenSource var1);

    public IRegistration thenTransferToAsync(Executor var1, ICancelTokenSource var2);

    public IRegistration thenTransferToAsync(Executor var1, ICancelTokenSource var2, int var3);
}

