/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.concurrent;

public final class TaskOptions {
    public static final int OFFSET_PRIORITY = 8;
    public static final int OFFSET_SCHEDULE_PHASE = 13;
    public static final int MAX_PRIORITY = 31;
    public static final int MAX_SCHEDULE_PHASE = 31;
    public static final int MASK_CTL_RESERVED = 255;
    public static final int MASK_PRIORITY = 7936;
    public static final int MASK_SCHEDULE_PHASE = 253952;
    public static final int SCHEDULE_BARRIER = 262144;
    public static final int LOCAL_ORDER = 524288;
    public static final int WAKEUP_THREAD = 0x100000;
    public static final int CAUGHT_EXCEPTION = 0x200000;
    public static final int TIMEOUT_BEFORE_RUN = 0x400000;
    public static final int STAGE_TRY_INLINE = 0x800000;
    public static final int STAGE_UNCANCELLABLE_CTX = 0x1000000;
    public static final int STAGE_LISTEN_CANCEL_TOKEN = 0x2000000;
    private static final int SUPPRESS_CANCELLATION_THROW = 0x4000000;
    private static final int SUPPRESS_ERROR_THROW = 0x8000000;

    public static boolean isEnabled(int flags, int option) {
        return (flags & option) == option;
    }

    public static boolean isDisabled(int flags, int option) {
        return (flags & option) != option;
    }

    public static int enable(int flags, int option) {
        return flags | option;
    }

    public static int disable(int flags, int option) {
        return flags & ~option;
    }

    public static int setEnable(int flags, int option, boolean enable) {
        if (enable) {
            return flags | option;
        }
        return flags & ~option;
    }

    public static int getPriority(int options) {
        return (options & 0x1F00) >> 8;
    }

    public static int setPriority(int options, int priority) {
        if (priority < 0 || priority > 31) {
            throw new IllegalArgumentException("priority: " + priority);
        }
        options &= 0xFFFFE0FF;
        return options |= priority << 8;
    }

    public static int getSchedulePhase(int options) {
        return (options & 0x3E000) >> 13;
    }

    public static int setSchedulePhase(int options, int phase) {
        if (phase < 0 || phase > 31) {
            throw new IllegalArgumentException("phase: " + phase);
        }
        options &= 0xFFFC1FFF;
        return options |= phase << 13;
    }
}

