/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.fx;

import cn.wjybxx.base.AbstractConstant;
import cn.wjybxx.base.Constant;
import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.fx.ComponentKind;
import cn.wjybxx.base.fx.IComponent;
import java.util.Objects;

public class ComponentId<T extends IComponent>
extends AbstractConstant {
    public final int index;
    public final ComponentKind kind;
    public final boolean shared;
    public final int maxCount;
    public final long enableFuncs;
    public final long flags;
    public final String mountPath;
    public final Object extraInfo;

    protected ComponentId(Builder<T> builder) {
        super(builder);
        assert (builder.getCacheIndex() >= 0);
        this.index = builder.getCacheIndex();
        this.kind = Objects.requireNonNull(builder.kind, "kind");
        this.shared = builder.shared;
        this.maxCount = Math.max(1, builder.maxCount);
        this.enableFuncs = builder.enableFuncs;
        this.flags = builder.flags;
        this.mountPath = ObjectUtils.blankToDef(builder.mountPath, null);
        this.extraInfo = builder.extraInfo;
    }

    public final boolean isPrivateScript() {
        return !this.shared && this.kind == ComponentKind.SCRIPT;
    }

    public static <T extends IComponent> Builder<T> newBuilder(String name) {
        return new Builder(name);
    }

    public static class Builder<T extends IComponent>
    extends Constant.Builder<ComponentId<T>> {
        private ComponentKind kind = ComponentKind.SCRIPT;
        private boolean shared = false;
        private int maxCount = 1;
        private long enableFuncs;
        private long flags;
        private String mountPath;
        private Object extraInfo;

        protected Builder(String name) {
            super(name);
            this.setRequireCacheIndex(true);
        }

        @Override
        protected ComponentId<T> build() {
            return new ComponentId(this);
        }

        public ComponentKind getKind() {
            return this.kind;
        }

        public Builder<T> setKind(ComponentKind kind) {
            this.kind = kind;
            return this;
        }

        public boolean isShared() {
            return this.shared;
        }

        public Builder<T> setShared(boolean shared) {
            this.shared = shared;
            return this;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public Builder<T> setMaxCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public long getEnableFuncs() {
            return this.enableFuncs;
        }

        public Builder<T> setEnableFuncs(long enableFuncs) {
            this.enableFuncs = enableFuncs;
            return this;
        }

        public long getFlags() {
            return this.flags;
        }

        public Builder<T> setFlags(long flags) {
            this.flags = flags;
            return this;
        }

        public String getMountPath() {
            return this.mountPath;
        }

        public Builder<T> setMountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public Object getExtraInfo() {
            return this.extraInfo;
        }

        public Builder<T> setExtraInfo(Object extraInfo) {
            this.extraInfo = extraInfo;
            return this;
        }
    }
}

