/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.fx;

import cn.wjybxx.base.ConstantMap;
import cn.wjybxx.base.ConstantPool;
import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.fx.ComponentDefine;
import cn.wjybxx.base.fx.ComponentId;
import cn.wjybxx.base.fx.ComponentRedirect;
import cn.wjybxx.base.fx.IComponent;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class ComponentIdPool {
    private final ConstantPool<ComponentId<?>> pool;
    private final Function<Class<?>, ComponentId.Builder<?>> cidParser;
    private final ConcurrentHashMap<Class<?>, ComponentId<?>> class2CidMap = new ConcurrentHashMap();

    private ComponentIdPool(ConstantPool<ComponentId<?>> pool, Function<Class<?>, ComponentId.Builder<?>> cidParser) {
        this.pool = pool;
        this.cidParser = cidParser;
    }

    public static ComponentIdPool newPool() {
        return new ComponentIdPool(ConstantPool.newPool(null), null);
    }

    public static ComponentIdPool newPool(Function<Class<?>, ComponentId.Builder<?>> cidParser) {
        return new ComponentIdPool(ConstantPool.newPool(null), cidParser);
    }

    public <T extends IComponent> ComponentId<T> create(ComponentId.Builder<T> builder) {
        return this.pool.newInstance(builder);
    }

    public <T extends IComponent> ComponentId<T> valueOf(ComponentId.Builder<T> builder) {
        return this.pool.valueOf(builder);
    }

    public boolean exists(String name) {
        return this.pool.exists(name);
    }

    public ComponentId<?> get(String name) {
        return this.pool.get(name);
    }

    public ComponentId<?> getOrThrow(String name) {
        return this.pool.getOrThrow(name);
    }

    public ConstantMap<ComponentId<?>> newConstantMap() {
        return this.pool.newConstantMap();
    }

    public <T extends IComponent> ComponentId<? super T> valueOf(Class<T> clazz) {
        ComponentId.Builder<Object> builder;
        Objects.requireNonNull(clazz, "clazz");
        ComponentId<?> cid = this.class2CidMap.get(clazz);
        if (cid != null) {
            return cid;
        }
        ComponentRedirect annotationRedirect = clazz.getAnnotation(ComponentRedirect.class);
        if (annotationRedirect != null) {
            cid = this.valueOf(annotationRedirect.value());
            this.class2CidMap.put(clazz, cid);
            return cid;
        }
        if (this.cidParser != null) {
            builder = this.cidParser.apply(clazz);
        } else {
            ComponentDefine annotationDefine = clazz.getAnnotation(ComponentDefine.class);
            if (annotationDefine == null) {
                builder = ComponentId.newBuilder(clazz.getSimpleName());
            } else {
                String compName = annotationDefine.name();
                if (ObjectUtils.isBlank(compName)) {
                    compName = clazz.getSimpleName();
                }
                builder = ComponentId.newBuilder(compName).setKind(annotationDefine.kind()).setShared(annotationDefine.shared()).setMaxCount(annotationDefine.maxCount()).setFlags(annotationDefine.flags()).setMountPath(annotationDefine.mountPath());
            }
        }
        cid = this.pool.valueOf(builder);
        this.class2CidMap.put(clazz, cid);
        return cid;
    }
}

