/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.fx;

import cn.wjybxx.base.EnumLite;
import cn.wjybxx.base.EnumLiteMap;
import cn.wjybxx.base.EnumUtils;

public enum ComponentStatus implements EnumLite
{
    NEW(0),
    READY(1),
    STARTING(2),
    RUNNING(3),
    STOPPING(4),
    STOPPED(5),
    DESTROYED(6);

    private final int number;
    private static final EnumLiteMap<ComponentStatus> MAPPER;

    private ComponentStatus(int number) {
        this.number = number;
    }

    public boolean isUnstarted() {
        return this.number < 2;
    }

    public boolean isStopping() {
        return this.number >= 4;
    }

    public boolean isStopped() {
        return this.number >= 5;
    }

    public boolean isDestroyed() {
        return this.number == 6;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public static ComponentStatus forNumber(int number) {
        return MAPPER.checkedForNumber(number);
    }

    static {
        MAPPER = EnumUtils.mapping((EnumLite[])ComponentStatus.values());
    }
}

