/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;

public final class TypeParameterFinder {
    public static Type getGenericSuperType(Class<?> thisClass, Class<?> superClazzOrInterface) {
        assert (superClazzOrInterface.isAssignableFrom(thisClass));
        if (thisClass == superClazzOrInterface) {
            throw new IllegalArgumentException("thisClass == superClazzOrInterface");
        }
        if (superClazzOrInterface.isInterface()) {
            Class<?> directChildClass = TypeParameterFinder.findInterfaceDirectChildClass(thisClass, superClazzOrInterface);
            return TypeParameterFinder.getGenericInterface(directChildClass, superClazzOrInterface);
        }
        Class<?> currentClass = thisClass;
        while (currentClass.getSuperclass() != superClazzOrInterface) {
            currentClass = currentClass.getSuperclass();
        }
        return currentClass.getGenericSuperclass();
    }

    public static <T> Class<?> findTypeParameter(T instance, Class<? super T> superClazzOrInterface, String typeParamName) {
        Objects.requireNonNull(instance, "instance");
        Class<?> thisClass = instance.getClass();
        return TypeParameterFinder.findTypeParameterUnsafe(thisClass, superClazzOrInterface, typeParamName);
    }

    public static Class<?> findTypeParameterUnsafe(Class<?> thisClass, Class<?> superClazzOrInterface, String typeParamName) {
        Objects.requireNonNull(thisClass, "thisClass");
        Objects.requireNonNull(superClazzOrInterface, "superClazzOrInterface");
        Objects.requireNonNull(typeParamName, "typeParamName");
        if (thisClass == superClazzOrInterface || !superClazzOrInterface.isAssignableFrom(thisClass)) {
            throw new IllegalArgumentException("superClazz error");
        }
        if (TypeParameterFinder.indexTypeParam(superClazzOrInterface, typeParamName) < 0) {
            throw new IllegalArgumentException("typeVarName %s is not declared in superClazz/interface %s".formatted(typeParamName, superClazzOrInterface.getSimpleName()));
        }
        if (superClazzOrInterface.isInterface()) {
            return TypeParameterFinder.findInterfaceTypeParameter(thisClass, superClazzOrInterface, typeParamName);
        }
        return TypeParameterFinder.find0(thisClass, superClazzOrInterface, typeParamName);
    }

    private static Class<?> findInterfaceTypeParameter(Class<?> thisClass, Class<?> parametrizedInterface, String typeParamName) {
        Class<?> directChildClass = TypeParameterFinder.findInterfaceDirectChildClass(thisClass, parametrizedInterface);
        return TypeParameterFinder.parseTypeParameter(thisClass, directChildClass, parametrizedInterface, typeParamName);
    }

    private static Class<?> findInterfaceDirectChildClass(Class<?> currentClazzOrInterface, Class<?> parametrizedInterface) {
        Class<?>[] implementationInterfaces;
        if (!parametrizedInterface.isAssignableFrom(currentClazzOrInterface)) {
            throw new IllegalArgumentException("currentClazzOrInterface = %s ,parametrizedInterface = %s".formatted(currentClazzOrInterface.getSimpleName(), parametrizedInterface.getSimpleName()));
        }
        for (Class<?> clazz : implementationInterfaces = currentClazzOrInterface.getInterfaces()) {
            if (clazz != parametrizedInterface) continue;
            return currentClazzOrInterface;
        }
        Class<?> superclass = currentClazzOrInterface.getSuperclass();
        if (null != superclass && parametrizedInterface.isAssignableFrom(superclass)) {
            return TypeParameterFinder.findInterfaceDirectChildClass(superclass, parametrizedInterface);
        }
        assert (parametrizedInterface.isInterface()) : "currentClazzOrInterface " + currentClazzOrInterface.getSimpleName() + " i";
        for (Class<?> superInterface : implementationInterfaces) {
            if (!parametrizedInterface.isAssignableFrom(superInterface)) continue;
            return TypeParameterFinder.findInterfaceDirectChildClass(superInterface, parametrizedInterface);
        }
        throw new AssertionError();
    }

    private static Class<?> parseTypeParameter(Class<?> thisClass, Class<?> directChildClass, Class<?> parametrizedSuperInterface, String typeParamName) {
        int typeParamIndex = TypeParameterFinder.indexTypeParam(parametrizedSuperInterface, typeParamName);
        assert (typeParamIndex >= 0);
        Type genericSuperInterface = TypeParameterFinder.getGenericInterface(directChildClass, parametrizedSuperInterface);
        if (!(genericSuperInterface instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] actualTypeParams = ((ParameterizedType)genericSuperInterface).getActualTypeArguments();
        Type actualTypeParam = actualTypeParams[typeParamIndex];
        if (actualTypeParam instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualTypeParam;
            actualTypeParam = parameterizedType.getRawType();
        }
        if (actualTypeParam instanceof Class) {
            Class clazz = (Class)actualTypeParam;
            return clazz;
        }
        if (actualTypeParam instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)actualTypeParam;
            Type componentType = arrayType.getGenericComponentType();
            if (componentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)componentType;
                componentType = parameterizedType.getRawType();
            }
            if (componentType instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
        }
        if (actualTypeParam instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)actualTypeParam;
            Object d = typeVar.getGenericDeclaration();
            if (!(d instanceof Class)) {
                return Object.class;
            }
            Class genericDeclarationClass = (Class)d;
            if (parametrizedSuperInterface.isAssignableFrom(thisClass)) {
                return TypeParameterFinder.findTypeParameterUnsafe(thisClass, genericDeclarationClass, typeVar.getName());
            }
            return Object.class;
        }
        return TypeParameterFinder.fail(thisClass, typeParamName);
    }

    private static Type getGenericInterface(Class<?> directChildClass, Class<?> superInterface) {
        Class<?>[] extendsOrImpInterfaces = directChildClass.getInterfaces();
        for (int index = 0; index < extendsOrImpInterfaces.length; ++index) {
            if (extendsOrImpInterfaces[index] != superInterface) continue;
            return directChildClass.getGenericInterfaces()[index];
        }
        throw new AssertionError((Object)"genericSuperInterface");
    }

    private static int indexTypeParam(Class<?> clazz, String typeVarName) {
        TypeVariable<Class<?>>[] typeParams = clazz.getTypeParameters();
        for (int idx = 0; idx < typeParams.length; ++idx) {
            if (!typeVarName.equals(typeParams[idx].getName())) continue;
            return idx;
        }
        return -1;
    }

    private static Class<?> fail(Class<?> type, String typeParamName) {
        throw new IllegalStateException("cannot determine the type of the type parameter '%s': %s".formatted(typeParamName, type));
    }

    private static Class<?> find0(Class<?> thisClass, Class<?> parametrizedSuperclass, String typeParamName) {
        Class<?> currentClass = thisClass;
        while (true) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = TypeParameterFinder.indexTypeParam(parametrizedSuperclass, typeParamName);
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '%s': %s".formatted(typeParamName, parametrizedSuperclass));
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)actualTypeParam;
                    actualTypeParam = parameterizedType.getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    Class clazz = (Class)actualTypeParam;
                    return clazz;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)actualTypeParam;
                    Type componentType = arrayType.getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    TypeVariable typeVar = (TypeVariable)actualTypeParam;
                    currentClass = thisClass;
                    if (!(typeVar.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    parametrizedSuperclass = (Class)typeVar.getGenericDeclaration();
                    typeParamName = typeVar.getName();
                    if (parametrizedSuperclass.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                return TypeParameterFinder.fail(thisClass, typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        return TypeParameterFinder.fail(thisClass, typeParamName);
    }
}

