/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.time;

import cn.wjybxx.base.time.TimeUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TimeHelper {
    private static final TimeHelper CST = new TimeHelper(TimeUtils.ZONE_OFFSET_CST);
    private static final TimeHelper UTC = new TimeHelper(TimeUtils.ZONE_OFFSET_UTC);
    public static final TimeHelper SYSTEM = new TimeHelper(TimeUtils.ZONE_OFFSET_SYSTEM);
    protected final ZoneOffset zoneOffset;

    protected TimeHelper(ZoneOffset zoneOffset) {
        this.zoneOffset = zoneOffset;
    }

    public static TimeHelper of(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(TimeHelper.CST.zoneOffset)) {
            return CST;
        }
        if (zoneOffset.equals(TimeHelper.SYSTEM.zoneOffset)) {
            return SYSTEM;
        }
        if (zoneOffset.equals(TimeHelper.UTC.zoneOffset)) {
            return UTC;
        }
        return new TimeHelper(zoneOffset);
    }

    public ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }

    public long getOffsetSeconds() {
        return this.zoneOffset.getTotalSeconds();
    }

    public long getOffsetMillis() {
        return (long)this.zoneOffset.getTotalSeconds() * 1000L;
    }

    public long toEpochMillis(LocalDateTime localDateTime) {
        long millis = (long)localDateTime.getNano() / 1000000L;
        return localDateTime.toEpochSecond(this.zoneOffset) * 1000L + millis;
    }

    public int toEpochDay(long epochMilli) {
        return this.toEpochDay(epochMilli, true);
    }

    public int toEpochDay(long epochMilli, boolean ceil) {
        long localSecond = epochMilli / 1000L + (long)this.zoneOffset.getTotalSeconds();
        int localEpochDay = (int)(localSecond / 86400L);
        return ceil ? localEpochDay + 1 : localEpochDay;
    }

    public LocalDateTime toDateTime(long epochMilli) {
        long extraMilli = epochMilli % 1000L;
        int nanoOfSecond = (int)(extraMilli * 1000000L);
        return LocalDateTime.ofEpochSecond(epochMilli / 1000L, nanoOfSecond, this.zoneOffset);
    }

    public LocalDateTime toDateTimeIgnoreMs(long epochMilli) {
        return LocalDateTime.ofEpochSecond(epochMilli / 1000L, 0, this.zoneOffset);
    }

    public String formatTime(long epochMilli) {
        return this.formatTime(epochMilli, TimeUtils.DEFAULT_FORMATTER);
    }

    public String formatTime(long epochMilli, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = this.toDateTime(epochMilli);
        return formatter.format(localDateTime);
    }

    public long parseTimeMillis(String dateString) {
        return this.toEpochMillis(LocalDateTime.parse(dateString, TimeUtils.DEFAULT_FORMATTER));
    }

    public long parseTimeMillis(String dateString, DateTimeFormatter formatter) {
        return this.toEpochMillis(LocalDateTime.parse(dateString, formatter));
    }

    public long getTimeHourOfToday(long epochMilli, int hour) {
        LocalDateTime localDateTime = this.toDateTimeIgnoreMs(epochMilli).with(LocalTime.of(hour, 0));
        return this.toEpochMillis(localDateTime);
    }

    public long getBeginOfToday(long epochMilli) {
        LocalDateTime localDateTime = this.toDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY);
        return this.toEpochMillis(localDateTime);
    }

    public long getEndOfToday(long epochMilli) {
        LocalDateTime localDateTime = this.toDateTimeIgnoreMs(epochMilli).with(TimeUtils.END_OF_DAY);
        return this.toEpochMillis(localDateTime);
    }

    public long getBeginOfWeek(long epochMilli) {
        LocalDateTime startOfDay = this.toDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY);
        int deltaDay = startOfDay.getDayOfWeek().getValue() - DayOfWeek.MONDAY.getValue();
        return this.toEpochMillis(startOfDay) - (long)deltaDay * 86400000L;
    }

    public long getEndOfWeek(long epochMilli) {
        return this.getBeginOfWeek(epochMilli) + 604800000L - 1L;
    }

    public long getBeginOfMonth(long epochMilli) {
        LocalDateTime firstDayOfMonth = this.toDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY).withDayOfMonth(1);
        return this.toEpochMillis(firstDayOfMonth);
    }

    public long getEndOfMonth(long epochMilli) {
        LocalDateTime endOfDay = this.toDateTimeIgnoreMs(epochMilli).with(TimeUtils.END_OF_DAY);
        LocalDateTime lastDayOfMonth = endOfDay.withDayOfMonth(TimeUtils.lengthOfMonth(endOfDay));
        return this.toEpochMillis(lastDayOfMonth);
    }

    public long getBeginOfMonth(long epochMilli, int deltaMonth) {
        LocalDateTime firstDayOfNextMonth = this.toDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY).withDayOfMonth(1).plusMonths(deltaMonth);
        return this.toEpochMillis(firstDayOfNextMonth);
    }

    public long getEndOfMonth(long epochMilli, int deltaMonth) {
        LocalDateTime firstDayOfNextMonth = this.toDateTimeIgnoreMs(epochMilli).with(TimeUtils.END_OF_DAY).withDayOfMonth(1).plusMonths(deltaMonth);
        LocalDateTime lastDayOfMonth = firstDayOfNextMonth.withDayOfMonth(TimeUtils.lengthOfMonth(firstDayOfNextMonth));
        return this.toEpochMillis(lastDayOfMonth);
    }

    public boolean isSameDay(long time1, long time2) {
        return this.toEpochDay(time1) == this.toEpochDay(time2);
    }

    public int differDays(long time1, long time2) {
        return Math.abs(this.toEpochDay(time1) - this.toEpochDay(time2));
    }

    public boolean isSameWeek(long time1, long time2) {
        return this.getBeginOfWeek(time1) == this.getBeginOfWeek(time2);
    }

    public int differWeeks(long time1, long time2) {
        long deltaTime = this.getBeginOfWeek(time1) - this.getBeginOfWeek(time2);
        return (int)Math.abs(deltaTime / 604800000L);
    }

    public String toString(LocalDateTime localDateTime) {
        return TimeHelper.toString(localDateTime.toLocalDate()) + "T" + TimeHelper.toString(localDateTime.toLocalTime()) + this.zoneOffset.toString();
    }

    public static String toString(LocalDate localDate) {
        return localDate.toString();
    }

    public static String toString(LocalTime localTime) {
        int hourValue = localTime.getHour();
        int minuteValue = localTime.getMinute();
        int secondValue = localTime.getSecond();
        int nanoValue = localTime.getNano();
        StringBuilder buf = new StringBuilder(18).append(hourValue < 10 ? "0" : "").append(hourValue).append(minuteValue < 10 ? ":0" : ":").append(minuteValue).append(secondValue < 10 ? ":0" : ":").append(secondValue);
        int milliValue = (int)((long)nanoValue / 1000000L);
        if (milliValue > 0) {
            buf.append('.');
            if (milliValue < 10) {
                buf.append("00").append(milliValue);
            } else if (milliValue < 100) {
                buf.append("0").append(milliValue);
            } else {
                buf.append(milliValue);
            }
        }
        return buf.toString();
    }

    public static String toString(ZoneOffset zoneOffset) {
        int totalSeconds = zoneOffset.getTotalSeconds();
        if (totalSeconds == 0) {
            return "Z";
        }
        int absTotalSeconds = Math.abs(totalSeconds);
        int absHours = absTotalSeconds / 3600;
        int absMinutes = absTotalSeconds / 60 % 60;
        StringBuilder buf = new StringBuilder().append(totalSeconds < 0 ? "-" : "+").append(absHours < 10 ? "0" : "").append(absHours).append(absMinutes < 10 ? ":0" : ":").append(absMinutes);
        return buf.toString();
    }
}

