/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.time;

import cn.wjybxx.base.time.CachedTimeProvider;
import cn.wjybxx.base.time.TimeProvider;
import cn.wjybxx.base.time.Timepiece;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

public class TimeProviders {
    private TimeProviders() {
    }

    public static TimeProvider systemMillisProvider() {
        return SystemTimeProvider.INSTANCE;
    }

    public static TimeProvider systemNanosProvider() {
        return SystemNanoTimeProvider.INSTANCE;
    }

    public static CachedTimeProvider newTimeProvider(long curTime) {
        return new UnsharableCachedTimeProvider(curTime);
    }

    public static Timepiece newTimepiece() {
        return new UnsharableTimepiece();
    }

    @ThreadSafe
    private static class SystemTimeProvider
    implements TimeProvider {
        static final SystemTimeProvider INSTANCE = new SystemTimeProvider();

        private SystemTimeProvider() {
        }

        @Override
        public long getTime() {
            return System.currentTimeMillis();
        }

        public String toString() {
            return "SystemTimeProvider{}";
        }
    }

    private static class SystemNanoTimeProvider
    implements TimeProvider {
        static final SystemNanoTimeProvider INSTANCE = new SystemNanoTimeProvider();

        private SystemNanoTimeProvider() {
        }

        @Override
        public long getTime() {
            return System.nanoTime();
        }

        public String toString() {
            return "SystemNanoTimeProvider{}";
        }
    }

    @NotThreadSafe
    private static class UnsharableCachedTimeProvider
    implements CachedTimeProvider {
        private long time;

        private UnsharableCachedTimeProvider(long time) {
            this.time = time;
        }

        @Override
        public void setTime(long curTime) {
            this.time = curTime;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        public String toString() {
            return "UnsharableCachedTimeProvider{curTime=" + this.time + "}";
        }
    }

    @NotThreadSafe
    private static class UnsharableTimepiece
    implements Timepiece {
        private long time;
        private int deltaTime;
        private int frameCount;

        private UnsharableTimepiece() {
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public int getDeltaTime() {
            return this.deltaTime;
        }

        @Override
        public int getFrameCount() {
            return this.frameCount;
        }

        @Override
        public void update(int deltaTime) {
            if (deltaTime <= 0) {
                this.deltaTime = 0;
            } else {
                this.deltaTime = deltaTime;
                this.time += (long)deltaTime;
            }
            ++this.frameCount;
        }

        @Override
        public void setTime(long curTime) {
            this.time = curTime;
        }

        @Override
        public void setDeltaTime(int deltaTime) {
            UnsharableTimepiece.checkDeltaTime(deltaTime);
            this.deltaTime = deltaTime;
        }

        @Override
        public void setFrameCount(int frameCount) {
            UnsharableTimepiece.checkFrameCount(frameCount);
            this.frameCount = frameCount;
        }

        @Override
        public void restart(long curTime, int deltaTime, int frameCount) {
            UnsharableTimepiece.checkDeltaTime(deltaTime);
            UnsharableTimepiece.checkFrameCount(frameCount);
            this.time = curTime;
            this.deltaTime = deltaTime;
            this.frameCount = frameCount;
        }

        @Override
        public void restart() {
            this.time = 0L;
            this.deltaTime = 0;
            this.frameCount = 0;
        }

        private static void checkFrameCount(int frameCount) {
            if (frameCount < 0) {
                throw new IllegalArgumentException("frameCount must gte 0,  value " + frameCount);
            }
        }

        private static void checkDeltaTime(int deltaTime) {
            if (deltaTime < 0) {
                throw new IllegalArgumentException("deltaTime must gte 0,  value " + deltaTime);
            }
        }
    }
}

