/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

public class CancelCodes {
    public static final int MASK_REASON = 1048575;
    public static final int MASK_DEGREE = 0xF00000;
    public static final int MASK_REVERSED = 0xF000000;
    public static final int MASK_INTERRUPT = 0x10000000;
    public static final int MASK_WITHOUT_REMOVE = 0x20000000;
    public static final int MASK_FROM_FUTURE = 0x40000000;
    public static final int MAX_REASON = 1048575;
    public static final int MAX_DEGREE = 15;
    public static final int OFFSET_REASON = 0;
    public static final int OFFSET_DEGREE = 20;
    public static final int REASON_DEFAULT = 1;
    public static final int REASON_TIMEOUT = 2;
    public static final int REASON_SHUTDOWN = 3;

    private CancelCodes() {
    }

    public static boolean isCancelling(int code) {
        return code != 0;
    }

    public static int getReason(int code) {
        return code & 0xFFFFF;
    }

    public static int getDegree(int code) {
        return (code & 0xF00000) >>> 20;
    }

    public static boolean isInterruptible(int code) {
        return (code & 0x10000000) != 0;
    }

    public static boolean isWithoutRemove(int code) {
        return (code & 0x20000000) != 0;
    }

    public static boolean isFromFuture(int code) {
        return (code & 0x40000000) != 0;
    }

    public static int setDegree(int code, int value) {
        if (value < 0 || value > 15) {
            throw new IllegalArgumentException("degree");
        }
        code &= 0xFF0FFFFF;
        return code |= value << 20;
    }

    public static int setReason(int code, int value) {
        if (value <= 0 || value > 1048575) {
            throw new IllegalArgumentException("reason");
        }
        code &= 0xFFF00000;
        return code |= value;
    }

    public static int setInterruptible(int code, boolean value) {
        return value ? code | 0x10000000 : code & 0xEFFFFFFF;
    }

    public static int setWithoutRemove(int code, boolean value) {
        return value ? code | 0x20000000 : code & 0xDFFFFFFF;
    }

    public static int checkCode(int code) {
        if (CancelCodes.getReason(code) == 0) {
            throw new IllegalArgumentException("reason is absent");
        }
        return code;
    }
}

