/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.BetterCancellationException;
import cn.wjybxx.concurrent.CancelCodes;
import cn.wjybxx.concurrent.CancelTokenListener;
import cn.wjybxx.concurrent.DefaultThreadFactory;
import cn.wjybxx.concurrent.FutureLogger;
import cn.wjybxx.concurrent.ICancelToken;
import cn.wjybxx.concurrent.ICancelTokenSource;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IExecutor;
import cn.wjybxx.concurrent.IRegistration;
import cn.wjybxx.concurrent.ITask;
import cn.wjybxx.concurrent.Promise;
import cn.wjybxx.concurrent.ReadonlyCancelToken;
import cn.wjybxx.concurrent.SingleThreadExecutor;
import cn.wjybxx.concurrent.TaskOption;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class CancelTokenSource
implements ICancelTokenSource {
    private static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DefaultThreadFactory("CancelTokenSource.Delayer", true));
    private volatile int code;
    private volatile Completion stack;
    private static final VarHandle VH_CODE;
    private static final VarHandle VH_STACK;
    private static final VarHandle VH_ACTION;
    private static final int SYNC = 0;
    private static final int ASYNC = 1;
    private static final int NESTED = -1;
    private static final Executor CLAIMED;
    private static final Completion TOMBSTONE;

    public CancelTokenSource() {
    }

    public CancelTokenSource(int code) {
        if (code != 0) {
            CancelCodes.checkCode(code);
            VH_CODE.setRelease(this, code);
        }
    }

    @Override
    public ICancelToken asReadonly() {
        return new ReadonlyCancelToken(this);
    }

    @Override
    public boolean canBeCancelled() {
        return true;
    }

    @Override
    public CancelTokenSource newInstance(boolean copyCode) {
        return new CancelTokenSource(copyCode ? this.code : 0);
    }

    @Override
    public int cancel(int cancelCode) {
        CancelCodes.checkCode(cancelCode);
        int preCode = this.internalCancel(cancelCode);
        if (preCode != 0) {
            return preCode;
        }
        CancelTokenSource.postComplete(this);
        return 0;
    }

    @Override
    public int cancel() {
        return this.cancel(1);
    }

    @Override
    public int cancel(boolean mayInterruptIfRunning) {
        return this.cancel(mayInterruptIfRunning ? 0 : 1);
    }

    @Override
    public void cancelAfter(int cancelCode, long millisecondsDelay) {
        this.cancelAfter(cancelCode, millisecondsDelay, TimeUnit.MILLISECONDS, delayer);
    }

    @Override
    public void cancelAfter(int cancelCode, long delay, TimeUnit timeUnit) {
        this.cancelAfter(cancelCode, delay, timeUnit, delayer);
    }

    public void cancelAfter(int cancelCode, long delay, TimeUnit timeUnit, ScheduledExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException("delayer is null");
        }
        if (this.code == 0) {
            Canceller canceller = new Canceller(this, cancelCode);
            canceller.future = executor.schedule(canceller, delay, timeUnit);
            this.thenNotify(canceller);
        }
    }

    @Override
    public int cancelCode() {
        return this.code;
    }

    @Override
    public boolean isCancelling() {
        return this.code != 0;
    }

    @Override
    public int reason() {
        return CancelCodes.getReason(this.code);
    }

    @Override
    public int degree() {
        return CancelCodes.getDegree(this.code);
    }

    @Override
    public boolean isInterruptible() {
        return CancelCodes.isInterruptible(this.code);
    }

    @Override
    public boolean isWithoutRemove() {
        return CancelCodes.isWithoutRemove(this.code);
    }

    @Override
    public void checkCancel() {
        int code = this.code;
        if (code != 0) {
            throw new BetterCancellationException(code);
        }
    }

    @Override
    public IRegistration thenAccept(Consumer<? super ICancelToken> action, int options) {
        return this.uniAccept(null, action, options);
    }

    @Override
    public IRegistration thenAccept(Consumer<? super ICancelToken> action) {
        return this.uniAccept(null, action, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, Consumer<? super ICancelToken> action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAccept(executor, action, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, Consumer<? super ICancelToken> action, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAccept(executor, action, options);
    }

    private IRegistration uniAccept(Executor executor, Consumer<? super ICancelToken> action, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniAccept.fireNow(this, action);
            return TOMBSTONE;
        }
        UniAccept completion = new UniAccept(executor, options, this, action);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> action, Object ctx, int options) {
        return this.uniAcceptCtx(null, action, ctx, options);
    }

    @Override
    public IRegistration thenAccept(BiConsumer<? super ICancelToken, Object> action, Object ctx) {
        return this.uniAcceptCtx(null, action, ctx, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, BiConsumer<? super ICancelToken, Object> action, Object ctx) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAcceptCtx(executor, action, ctx, 0);
    }

    @Override
    public IRegistration thenAcceptAsync(Executor executor, BiConsumer<? super ICancelToken, Object> action, Object ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniAcceptCtx(executor, action, ctx, options);
    }

    private IRegistration uniAcceptCtx(Executor executor, BiConsumer<? super ICancelToken, Object> action, Object ctx, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniAcceptCtx.fireNow(this, action, ctx);
            return TOMBSTONE;
        }
        UniAcceptCtx completion = new UniAcceptCtx(executor, options, this, action, ctx);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenRun(Runnable action, int options) {
        return this.uniRun(null, action, options);
    }

    @Override
    public IRegistration thenRun(Runnable action) {
        return this.uniRun(null, action, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Runnable action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRun(executor, action, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Runnable action, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRun(executor, action, options);
    }

    private IRegistration uniRun(Executor executor, Runnable action, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniRun.fireNow(action);
            return TOMBSTONE;
        }
        UniRun completion = new UniRun(executor, options, this, action);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenRun(Consumer<Object> action, Object ctx, int options) {
        return this.uniRunCtx(null, action, ctx, options);
    }

    @Override
    public IRegistration thenRun(Consumer<Object> action, Object ctx) {
        return this.uniRunCtx(null, action, ctx, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Consumer<Object> action, Object ctx) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRunCtx(executor, action, ctx, 0);
    }

    @Override
    public IRegistration thenRunAsync(Executor executor, Consumer<Object> action, Object ctx, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniRunCtx(executor, action, ctx, options);
    }

    private IRegistration uniRunCtx(Executor executor, Consumer<Object> action, Object ctx, int options) {
        Objects.requireNonNull(action);
        if (this.isCancelling() && executor == null) {
            UniRunCtx.fireNow(action, ctx);
            return TOMBSTONE;
        }
        UniRunCtx completion = new UniRunCtx(executor, options, this, action, ctx);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenNotify(CancelTokenListener action, int options) {
        return this.uniNotify(null, action, options);
    }

    @Override
    public IRegistration thenNotify(CancelTokenListener action) {
        return this.uniNotify(null, action, 0);
    }

    @Override
    public IRegistration thenNotifyAsync(Executor executor, CancelTokenListener action) {
        Objects.requireNonNull(executor, "executor");
        return this.uniNotify(executor, action, 0);
    }

    @Override
    public IRegistration thenNotifyAsync(Executor executor, CancelTokenListener action, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniNotify(executor, action, options);
    }

    private IRegistration uniNotify(Executor executor, CancelTokenListener action, int options) {
        if (this.isCancelling() && executor == null) {
            UniNotify.fireNow(this, action);
            return TOMBSTONE;
        }
        UniNotify completion = new UniNotify(executor, options, this, action);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    @Override
    public IRegistration thenTransferTo(ICancelTokenSource child) {
        return this.uniTransferTo(null, child, 0);
    }

    @Override
    public IRegistration thenTransferTo(ICancelTokenSource child, int options) {
        return this.uniTransferTo(null, child, options);
    }

    @Override
    public IRegistration thenTransferToAsync(Executor executor, ICancelTokenSource child) {
        Objects.requireNonNull(executor, "executor");
        return this.uniTransferTo(executor, child, 0);
    }

    @Override
    public IRegistration thenTransferToAsync(Executor executor, ICancelTokenSource child, int options) {
        Objects.requireNonNull(executor, "executor");
        return this.uniTransferTo(executor, child, options);
    }

    private IRegistration uniTransferTo(Executor executor, ICancelTokenSource child, int options) {
        Objects.requireNonNull(child, "child");
        if (this.isCancelling() && executor == null) {
            UniTransferTo.fireNow(this, 0, child);
            return TOMBSTONE;
        }
        UniTransferTo completion = new UniTransferTo(executor, options, this, child);
        return this.pushCompletion(completion) ? completion : TOMBSTONE;
    }

    private int internalCancel(int cancelCode) {
        return VH_CODE.compareAndExchange(this, 0, cancelCode);
    }

    private Completion removeClosedNode(Completion expectedHead) {
        Completion next = expectedHead.next;
        while (next != null && next.action == TOMBSTONE) {
            next = next.next;
        }
        Completion realHead = VH_STACK.compareAndExchange(this, expectedHead, next);
        return realHead == expectedHead ? next : realHead;
    }

    private boolean pushCompletion(Completion newHead) {
        if (this.isCancelling()) {
            newHead.tryFire(0);
            return false;
        }
        Completion expectedHead = this.stack;
        while (expectedHead != TOMBSTONE) {
            if (expectedHead != null && expectedHead.action == TOMBSTONE) {
                expectedHead = this.removeClosedNode(expectedHead);
                continue;
            }
            newHead.next = expectedHead;
            Completion realHead = VH_STACK.compareAndExchange(this, expectedHead, newHead);
            if (realHead == expectedHead) {
                return true;
            }
            expectedHead = realHead;
        }
        newHead.next = null;
        newHead.tryFire(0);
        return false;
    }

    private static void postComplete(CancelTokenSource source) {
        Completion next = null;
        block0: while (true) {
            next = CancelTokenSource.clearListeners(source, next);
            while (next != null) {
                Completion curr = next;
                next = next.next;
                curr.next = null;
                source = curr.tryFire(-1);
                if (source == null) continue;
                continue block0;
            }
            break;
        }
    }

    private static Completion clearListeners(CancelTokenSource source, Completion onto) {
        Completion head;
        do {
            if ((head = source.stack) != TOMBSTONE) continue;
            return onto;
        } while (!VH_STACK.compareAndSet(source, head, TOMBSTONE));
        Completion ontoHead = onto;
        while (head != null) {
            Completion tmpHead = head;
            head = head.next;
            if (tmpHead.action == TOMBSTONE) continue;
            tmpHead.next = ontoHead;
            ontoHead = tmpHead;
        }
        return ontoHead;
    }

    private static boolean tryInline(Completion completion, Executor e, int options) {
        SingleThreadExecutor eventLoop;
        if (TaskOption.isEnabled(options, 524288) && e instanceof SingleThreadExecutor && (eventLoop = (SingleThreadExecutor)e).inEventLoop()) {
            return true;
        }
        if (options != 0 && !TaskOption.isEnabled(options, 0x100000) && e instanceof IExecutor) {
            IExecutor exe = (IExecutor)e;
            exe.execute(completion);
        } else {
            completion.setOptions(0);
            e.execute(completion);
        }
        return false;
    }

    static {
        delayer.setRemoveOnCancelPolicy(true);
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VH_CODE = l.findVarHandle(CancelTokenSource.class, "code", Integer.TYPE);
            VH_STACK = l.findVarHandle(CancelTokenSource.class, "stack", Completion.class);
            VH_ACTION = l.findVarHandle(Completion.class, "action", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        CLAIMED = Promise.CLAIMED;
        TOMBSTONE = new Completion(){

            @Override
            public CancelTokenSource tryFire(int mode) {
                return null;
            }
        };
    }

    private static class Canceller
    implements Runnable,
    CancelTokenListener {
        final CancelTokenSource source;
        final int cancelCode;
        ScheduledFuture<?> future;

        private Canceller(CancelTokenSource source, int cancelCode) {
            this.source = source;
            this.cancelCode = cancelCode;
        }

        @Override
        public void run() {
            this.source.cancel(this.cancelCode);
        }

        @Override
        public void onCancelRequested(ICancelToken cancelToken) {
            this.future.cancel(false);
        }
    }

    private static class UniAccept
    extends Completion {
        public UniAccept(Executor executor, int options, CancelTokenSource source, Consumer<? super ICancelToken> action) {
            super(executor, options, source, action);
        }

        @Override
        public CancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                Consumer action = (Consumer)this.popAction();
                if (action == null) {
                    return null;
                }
                action.accept(this.source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAccept caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(CancelTokenSource source, Consumer<? super ICancelToken> action) {
            try {
                action.accept(source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAccept caught an exception");
            }
        }
    }

    private static abstract class Completion
    implements IRegistration,
    ITask {
        Completion next;
        Executor executor;
        int options;
        CancelTokenSource source;
        volatile Object action;

        public Completion() {
            this.source = null;
        }

        public Completion(Executor executor, int options, CancelTokenSource source, Object action) {
            this.executor = executor;
            this.options = options;
            this.source = source;
            VH_ACTION.setRelease(this, action);
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        public void setOptions(int options) {
            this.options = options;
        }

        @Override
        public final void run() {
            this.tryFire(1);
        }

        public abstract CancelTokenSource tryFire(int var1);

        public final boolean claim() {
            Executor e = this.executor;
            if (e == CLAIMED) {
                return true;
            }
            this.executor = CLAIMED;
            if (e == null) {
                return true;
            }
            return CancelTokenSource.tryInline(this, e, this.options);
        }

        @Nullable
        protected final Object popAction() {
            Object action = this.action;
            if (action == TOMBSTONE) {
                return null;
            }
            if (action == VH_ACTION.compareAndExchange(this, action, TOMBSTONE)) {
                return action;
            }
            return null;
        }

        @Override
        public final void close() {
            Object action = this.popAction();
            if (action == null) {
                return;
            }
            if (this == this.source.stack) {
                this.source.removeClosedNode(this);
            }
            this.clear();
        }

        protected void clear() {
            this.executor = null;
            this.source = null;
        }

        protected boolean isCancelling(Object ctx) {
            IContext ctx2;
            return TaskOption.isEnabled(this.options, 0x200000) && ctx instanceof IContext && (ctx2 = (IContext)ctx).cancelToken().isCancelling();
        }
    }

    private static class UniAcceptCtx
    extends Completion {
        Object ctx;

        public UniAcceptCtx(Executor executor, int options, CancelTokenSource source, BiConsumer<? super ICancelToken, Object> action, Object ctx) {
            super(executor, options, source, action);
            this.ctx = ctx;
        }

        @Override
        protected void clear() {
            super.clear();
            this.ctx = null;
        }

        @Override
        public CancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                BiConsumer action = (BiConsumer)this.popAction();
                if (action == null) {
                    return null;
                }
                if (!this.isCancelling(this.ctx)) {
                    action.accept(this.source, this.ctx);
                }
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAcceptCtx caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(CancelTokenSource source, BiConsumer<? super ICancelToken, Object> action, Object ctx) {
            try {
                action.accept(source, ctx);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniAcceptCtx caught an exception");
            }
        }
    }

    private static class UniRun
    extends Completion {
        public UniRun(Executor executor, int options, CancelTokenSource source, Runnable action) {
            super(executor, options, source, action);
        }

        @Override
        public CancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                Runnable action = (Runnable)this.popAction();
                if (action == null) {
                    return null;
                }
                action.run();
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRun caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(Runnable action) {
            try {
                action.run();
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRun caught an exception");
            }
        }
    }

    private static class UniRunCtx
    extends Completion {
        Object ctx;

        public UniRunCtx(Executor executor, int options, CancelTokenSource source, Consumer<Object> action, Object ctx) {
            super(executor, options, source, action);
            this.ctx = ctx;
        }

        @Override
        protected void clear() {
            super.clear();
            this.ctx = null;
        }

        @Override
        public CancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                Consumer action = (Consumer)this.popAction();
                if (action == null) {
                    return null;
                }
                if (!this.isCancelling(this.ctx)) {
                    action.accept(this.ctx);
                }
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRunCtx caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(Consumer<Object> action, Object ctx) {
            try {
                action.accept(ctx);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniRunCtx caught an exception");
            }
        }
    }

    private static class UniNotify
    extends Completion {
        public UniNotify(Executor executor, int options, CancelTokenSource source, CancelTokenListener action) {
            super(executor, options, source, action);
        }

        @Override
        public CancelTokenSource tryFire(int mode) {
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                CancelTokenListener action = (CancelTokenListener)this.popAction();
                if (action == null) {
                    return null;
                }
                action.onCancelRequested(this.source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniNotify caught an exception");
            }
            this.clear();
            return null;
        }

        static void fireNow(CancelTokenSource source, CancelTokenListener action) {
            try {
                action.onCancelRequested(source);
            }
            catch (Throwable ex) {
                FutureLogger.logCause(ex, "UniNotify caught an exception");
            }
        }
    }

    private static class UniTransferTo
    extends Completion {
        public UniTransferTo(Executor executor, int options, CancelTokenSource source, ICancelTokenSource action) {
            super(executor, options, source, action);
        }

        @Override
        public CancelTokenSource tryFire(int mode) {
            CancelTokenSource output;
            try {
                if (mode <= 0 && !this.claim()) {
                    return null;
                }
                ICancelTokenSource child = (ICancelTokenSource)this.popAction();
                if (child == null) {
                    return null;
                }
                output = UniTransferTo.fireNow(this.source, mode, child);
            }
            catch (Throwable ex) {
                output = null;
                FutureLogger.logCause(ex, "UniTransferTo caught an exception");
            }
            this.clear();
            return output;
        }

        static CancelTokenSource fireNow(CancelTokenSource source, int mode, ICancelTokenSource child) {
            if (!(child instanceof CancelTokenSource)) {
                child.cancel(source.code);
                return null;
            }
            CancelTokenSource childSource = (CancelTokenSource)child;
            if (childSource.internalCancel(source.code) == 0) {
                if (mode < 0) {
                    return childSource;
                }
                CancelTokenSource.postComplete(childSource);
                return null;
            }
            return null;
        }
    }
}

