/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.MathCommon;
import cn.wjybxx.concurrent.EventLoop;
import cn.wjybxx.concurrent.EventLoopChooser;
import cn.wjybxx.concurrent.EventLoopChooserFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

public class DefaultChooserFactory
implements EventLoopChooserFactory {
    @Override
    @Nonnull
    public EventLoopChooser newChooser(EventLoop[] children) {
        if (children.length == 1) {
            return new SingleEventLoopChooser(children[0]);
        }
        if (MathCommon.isPowerOfTwo((int)children.length)) {
            return new PowerOfTwoEventLoopChooser(children);
        }
        return new RoundRobinEventLoopChooser(children);
    }

    private static final class SingleEventLoopChooser
    implements EventLoopChooser {
        private final EventLoop eventLoop;

        private SingleEventLoopChooser(EventLoop eventLoop) {
            this.eventLoop = eventLoop;
        }

        @Override
        @Nonnull
        public EventLoop select() {
            return this.eventLoop;
        }

        @Override
        public EventLoop select(int key) {
            return this.eventLoop;
        }
    }

    private static final class PowerOfTwoEventLoopChooser
    implements EventLoopChooser {
        private final AtomicInteger idx = new AtomicInteger();
        private final EventLoop[] executors;

        PowerOfTwoEventLoopChooser(EventLoop[] executors) {
            this.executors = executors;
        }

        @Override
        @Nonnull
        public EventLoop select() {
            int key = this.idx.getAndIncrement();
            return this.executors[key & this.executors.length - 1];
        }

        @Override
        @Nonnull
        public EventLoop select(int key) {
            return this.executors[key & this.executors.length - 1];
        }
    }

    @ThreadSafe
    private static final class RoundRobinEventLoopChooser
    implements EventLoopChooser {
        private final AtomicInteger idx = new AtomicInteger();
        private final EventLoop[] executors;

        RoundRobinEventLoopChooser(EventLoop[] executors) {
            assert (executors.length > 0);
            this.executors = executors;
        }

        @Override
        @Nonnull
        public EventLoop select() {
            int key = this.idx.getAndIncrement();
            return this.executors[Math.abs(key % this.executors.length)];
        }

        @Override
        public EventLoop select(int key) {
            return this.executors[Math.abs(key % this.executors.length)];
        }
    }
}

