/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.function.TriConsumer;
import cn.wjybxx.concurrent.AbstractEventLoopGroup;
import cn.wjybxx.concurrent.DefaultChooserFactory;
import cn.wjybxx.concurrent.EventLoop;
import cn.wjybxx.concurrent.EventLoopChooser;
import cn.wjybxx.concurrent.EventLoopChooserFactory;
import cn.wjybxx.concurrent.EventLoopFactory;
import cn.wjybxx.concurrent.EventLoopGroup;
import cn.wjybxx.concurrent.EventLoopGroupBuilder;
import cn.wjybxx.concurrent.FixedEventLoopGroup;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFixedEventLoopGroup
extends AbstractEventLoopGroup
implements FixedEventLoopGroup {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFixedEventLoopGroup.class);
    private final IPromise<Void> terminationFuture = new Promise<Void>();
    private final EventLoop[] children;
    private final List<EventLoop> readonlyChildren;
    private final EventLoopChooser chooser;
    private final Runnable terminationHook;

    public DefaultFixedEventLoopGroup(EventLoopGroupBuilder builder) {
        int numChildren = builder.getNumChildren();
        if (numChildren < 1) {
            throw new IllegalArgumentException("childCount must greater than 0");
        }
        EventLoopFactory eventLoopFactory = builder.getEventLoopFactory();
        if (eventLoopFactory == null) {
            throw new NullPointerException("eventLoopFactory");
        }
        EventLoopChooserFactory chooserFactory = builder.getChooserFactory();
        if (chooserFactory == null) {
            chooserFactory = new DefaultChooserFactory();
        }
        this.children = new EventLoop[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            EventLoop eventLoop = Objects.requireNonNull(eventLoopFactory.newChild(this, i, null));
            if (eventLoop.parent() != this) {
                throw new IllegalStateException("the parent of child is illegal");
            }
            this.children[i] = eventLoop;
        }
        this.readonlyChildren = List.of(this.children);
        this.chooser = chooserFactory.newChooser((EventLoop[])this.children.clone());
        this.terminationHook = builder.getTerminationHook();
        ChildrenTerminateListener terminationListener = new ChildrenTerminateListener();
        for (EventLoop child : this.children) {
            child.terminationFuture().whenComplete(terminationListener);
        }
    }

    @Override
    public IFuture<?> terminationFuture() {
        return this.terminationFuture.asReadonly();
    }

    @Override
    public boolean isShuttingDown() {
        return Arrays.stream(this.children).allMatch(EventLoopGroup::isShuttingDown);
    }

    @Override
    public boolean isShutdown() {
        return Arrays.stream(this.children).allMatch(EventLoopGroup::isShutdown);
    }

    @Override
    public boolean isTerminated() {
        return this.terminationFuture.isDone();
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.terminationFuture().await(timeout, unit);
    }

    @Override
    public void shutdown() {
        this.forEach((Consumer<? super EventLoop>)((Consumer<EventLoop>)EventLoopGroup::shutdown));
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (EventLoop eventLoop : this.children) {
            tasks.addAll(eventLoop.shutdownNow());
        }
        return tasks;
    }

    protected void invokeTerminationHook() {
        if (this.terminationHook != null) {
            this.terminationHook.run();
        }
    }

    @Override
    public int childCount() {
        return this.children.length;
    }

    @Override
    @Nonnull
    public EventLoop select() {
        return this.chooser.select();
    }

    @Override
    @Nonnull
    public EventLoop select(int key) {
        return this.chooser.select(key);
    }

    @Override
    @Nonnull
    public Iterator<EventLoop> iterator() {
        return this.readonlyChildren.iterator();
    }

    @Override
    public void forEach(Consumer<? super EventLoop> action) {
        this.readonlyChildren.forEach(action);
    }

    @Override
    public Spliterator<EventLoop> spliterator() {
        return this.readonlyChildren.spliterator();
    }

    private class ChildrenTerminateListener
    implements TriConsumer<IContext, Object, Throwable> {
        private final AtomicInteger terminatedChildren = new AtomicInteger(0);

        private ChildrenTerminateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(IContext ctx, Object o, Throwable throwable) {
            if (this.terminatedChildren.incrementAndGet() == DefaultFixedEventLoopGroup.this.children.length) {
                try {
                    DefaultFixedEventLoopGroup.this.invokeTerminationHook();
                }
                catch (Throwable e) {
                    logger.error("terminateHook caught exception!", e);
                }
                finally {
                    DefaultFixedEventLoopGroup.this.terminationFuture.trySetResult(null);
                }
            }
        }
    }
}

