/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.EventLoopGroup;
import cn.wjybxx.concurrent.EventLoopModule;
import cn.wjybxx.concurrent.EventLoopState;
import cn.wjybxx.concurrent.FixedEventLoopGroup;
import cn.wjybxx.concurrent.GuardedOperationException;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.SingleThreadExecutor;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface EventLoop
extends FixedEventLoopGroup,
SingleThreadExecutor {
    @Override
    @Nonnull
    default public EventLoop select() {
        return this;
    }

    @Override
    @Nonnull
    default public EventLoop select(int key) {
        return this;
    }

    @Nullable
    public EventLoopGroup parent();

    @Override
    public boolean inEventLoop();

    @Override
    public boolean inEventLoop(Thread var1);

    public void wakeup();

    public EventLoopModule mainModule();

    default public void ensureInEventLoop() {
        if (!this.inEventLoop()) {
            throw new GuardedOperationException();
        }
    }

    default public void ensureInEventLoop(String method) {
        Objects.requireNonNull(method);
        if (!this.inEventLoop()) {
            throw new GuardedOperationException("Calling " + method + " must in the EventLoop");
        }
    }

    public EventLoopState state();

    public boolean isRunning();

    public IFuture<?> runningFuture();

    public IFuture<?> start();
}

