/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.concurrent.DefaultThreadFactory;
import cn.wjybxx.concurrent.DisruptorEventLoop;
import cn.wjybxx.concurrent.EventLoop;
import cn.wjybxx.concurrent.EventLoopAgent;
import cn.wjybxx.concurrent.EventLoopGroup;
import cn.wjybxx.concurrent.EventLoopModule;
import cn.wjybxx.concurrent.IAgentEvent;
import cn.wjybxx.concurrent.RejectedExecutionHandler;
import cn.wjybxx.concurrent.RejectedExecutionHandlers;
import cn.wjybxx.disruptor.EventSequencer;
import cn.wjybxx.disruptor.WaitStrategy;
import java.util.concurrent.ThreadFactory;

public abstract class EventLoopBuilder<T extends IAgentEvent> {
    private EventLoopGroup parent;
    private RejectedExecutionHandler rejectedExecutionHandler = RejectedExecutionHandlers.abort();
    private ThreadFactory threadFactory;
    private EventLoopAgent<? super T> agent;
    private EventLoopModule mainModule;
    private int batchSize = 1024;

    public abstract EventLoop build();

    public EventLoopGroup getParent() {
        return this.parent;
    }

    public EventLoopBuilder<T> setParent(EventLoopGroup parent) {
        this.parent = parent;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public EventLoopBuilder<T> setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public EventLoopBuilder<T> setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        return this;
    }

    public EventLoopAgent<? super T> getAgent() {
        return this.agent;
    }

    public EventLoopBuilder<T> setAgent(EventLoopAgent<? super T> agent) {
        this.agent = agent;
        return this;
    }

    public EventLoopModule getMainModule() {
        return this.mainModule;
    }

    public EventLoopBuilder<T> setMainModule(EventLoopModule mainModule) {
        this.mainModule = mainModule;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public EventLoopBuilder<T> setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public static <T extends IAgentEvent> DisruptorBuilder<T> newDisruptBuilder() {
        return new DisruptorBuilder();
    }

    public static <T extends IAgentEvent> DisruptorBuilder<T> newDisruptBuilder(EventSequencer<? extends T> eventSequencer) {
        return new DisruptorBuilder<T>().setEventSequencer(eventSequencer);
    }

    public static class DisruptorBuilder<T extends IAgentEvent>
    extends EventLoopBuilder<T> {
        private EventSequencer<? extends T> eventSequencer;
        private WaitStrategy waitStrategy;
        private boolean cleanBufferOnExit = true;

        @Override
        public DisruptorBuilder<T> setParent(EventLoopGroup parent) {
            super.setParent(parent);
            return this;
        }

        @Override
        public DisruptorBuilder<T> setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            super.setRejectedExecutionHandler(rejectedExecutionHandler);
            return this;
        }

        @Override
        public DisruptorBuilder<T> setThreadFactory(ThreadFactory threadFactory) {
            super.setThreadFactory(threadFactory);
            return this;
        }

        @Override
        public DisruptorBuilder<T> setAgent(EventLoopAgent<? super T> agent) {
            super.setAgent(agent);
            return this;
        }

        @Override
        public DisruptorBuilder<T> setMainModule(EventLoopModule mainModule) {
            super.setMainModule(mainModule);
            return this;
        }

        @Override
        public DisruptorBuilder<T> setBatchSize(int batchSize) {
            super.setBatchSize(batchSize);
            return this;
        }

        @Override
        public DisruptorEventLoop<T> build() {
            if (this.getThreadFactory() == null) {
                this.setThreadFactory(new DefaultThreadFactory("DisruptorEventLoop"));
            }
            if (this.eventSequencer == null) {
                throw new IllegalStateException("eventSequencer is null");
            }
            return new DisruptorEventLoop(this);
        }

        public EventSequencer<? extends T> getEventSequencer() {
            return this.eventSequencer;
        }

        public DisruptorBuilder<T> setEventSequencer(EventSequencer<? extends T> eventSequencer) {
            this.eventSequencer = eventSequencer;
            return this;
        }

        public WaitStrategy getWaitStrategy() {
            return this.waitStrategy;
        }

        public DisruptorBuilder<T> setWaitStrategy(WaitStrategy waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public boolean isCleanBufferOnExit() {
            return this.cleanBufferOnExit;
        }

        public DisruptorBuilder<T> setCleanBufferOnExit(boolean cleanBufferOnExit) {
            this.cleanBufferOnExit = cleanBufferOnExit;
            return this;
        }
    }
}

