/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.concurrent;

import cn.wjybxx.base.ThreadUtils;
import cn.wjybxx.base.function.TriFunction;
import cn.wjybxx.base.mutable.MutableObject;
import cn.wjybxx.base.time.CachedTimeProvider;
import cn.wjybxx.concurrent.EventLoop;
import cn.wjybxx.concurrent.FutureCombiner;
import cn.wjybxx.concurrent.GuardedOperationException;
import cn.wjybxx.concurrent.ICompletionStage;
import cn.wjybxx.concurrent.IContext;
import cn.wjybxx.concurrent.IExecutor;
import cn.wjybxx.concurrent.IFuture;
import cn.wjybxx.concurrent.IPromise;
import cn.wjybxx.concurrent.ITask;
import cn.wjybxx.concurrent.JDKFutureCombiner;
import cn.wjybxx.concurrent.Promise;
import cn.wjybxx.concurrent.PromiseTask;
import cn.wjybxx.concurrent.SingleThreadExecutor;
import cn.wjybxx.concurrent.TaskBuilder;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

public class FutureUtils {
    private static final TriFunction<IContext, Object, Throwable, Object> EXCEPTION_TO_NULL = (ctx, o, throwable) -> {
        if (throwable != null) {
            return null;
        }
        return o;
    };

    public static <V> BiFunction<V, Throwable, V> treatExceptionAsNull() {
        return (BiFunction)EXCEPTION_TO_NULL;
    }

    public static Throwable unwrapCompletionException(Throwable t) {
        while (t instanceof CompletionException && t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static Throwable getCause(CompletableFuture<?> future) {
        if (future.isCompletedExceptionally()) {
            return future.exceptionNow();
        }
        if (future.isCancelled()) {
            MutableObject causeHolder = new MutableObject();
            future.whenComplete((v, cause) -> causeHolder.setValue(cause));
            return (Throwable)causeHolder.getValue();
        }
        return null;
    }

    public static Throwable getCause(IFuture<?> future) {
        if (future.isFailedOrCancelled()) {
            return future.exceptionNow(false);
        }
        return null;
    }

    public static <V> IPromise<V> fromJDKFuture(CompletionStage<V> stage) {
        Promise promise = new Promise();
        stage.whenComplete((v, throwable) -> {
            if (throwable != null) {
                promise.trySetException((Throwable)throwable);
            } else {
                promise.trySetResult(v);
            }
        });
        return promise;
    }

    public static <V> CompletableFuture<V> toJDKFuture(ICompletionStage<V> stage) {
        CompletableFuture future = new CompletableFuture();
        stage.whenComplete((ctx, v, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete(v);
            }
        });
        return future;
    }

    public static <V> void setFuture(IPromise<? super V> output, ICompletionStage<V> input) {
        Objects.requireNonNull(output, "output");
        input.whenComplete((ctx, v, throwable) -> {
            if (throwable != null) {
                output.trySetException((Throwable)throwable);
            } else {
                output.trySetResult((Object)v);
            }
        });
    }

    public static <V> void setFuture(IPromise<? super V> output, CompletionStage<V> input) {
        Objects.requireNonNull(output, "output");
        input.whenComplete((v, throwable) -> {
            if (throwable != null) {
                output.trySetException((Throwable)throwable);
            } else {
                output.trySetResult((Object)v);
            }
        });
    }

    public static <V> void setFutureAsync(Executor executor, IPromise<? super V> output, ICompletionStage<V> input) {
        FutureUtils.setFutureAsync(executor, output, input, 0);
    }

    public static <V> void setFutureAsync(Executor executor, IPromise<? super V> output, ICompletionStage<V> input, int options) {
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(executor, "executor");
        input.whenCompleteAsync(executor, (ctx, v, throwable) -> {
            if (throwable != null) {
                output.trySetException((Throwable)throwable);
            } else {
                output.trySetResult((Object)v);
            }
        }, null, options);
    }

    public static <V> void setFutureAsync(Executor executor, IPromise<? super V> output, CompletionStage<V> input) {
        input.whenCompleteAsync((v, throwable) -> {
            if (throwable != null) {
                output.trySetException((Throwable)throwable);
            } else {
                output.trySetResult((Object)v);
            }
        }, executor);
    }

    public static <V> void setFuture(CompletableFuture<? super V> output, CompletionStage<V> input) {
        Objects.requireNonNull(output, "output");
        input.whenComplete((v, throwable) -> {
            if (throwable != null) {
                output.completeExceptionally((Throwable)throwable);
            } else {
                output.complete((Object)v);
            }
        });
    }

    public static <V> void setFuture(CompletableFuture<? super V> output, ICompletionStage<V> input) {
        Objects.requireNonNull(output, "output");
        input.whenComplete((ctx, v, throwable) -> {
            if (throwable != null) {
                output.completeExceptionally((Throwable)throwable);
            } else {
                output.complete((Object)v);
            }
        });
    }

    public static <V> void setFutureAsync(Executor executor, CompletableFuture<? super V> output, CompletionStage<V> input) {
        input.whenCompleteAsync((v, throwable) -> {
            if (throwable != null) {
                output.completeExceptionally((Throwable)throwable);
            } else {
                output.complete((Object)v);
            }
        }, executor);
    }

    public static <V> void setFutureAsync(Executor executor, CompletableFuture<? super V> output, ICompletionStage<V> input) {
        FutureUtils.setFutureAsync(executor, output, input, 0);
    }

    public static <V> void setFutureAsync(Executor executor, CompletableFuture<? super V> output, ICompletionStage<V> input, int options) {
        input.whenCompleteAsync(executor, (ctx, v, throwable) -> {
            if (throwable != null) {
                output.completeExceptionally((Throwable)throwable);
            } else {
                output.complete((Object)v);
            }
        }, null, options);
    }

    public static <V> IPromise<V> toEventLoopPromise(EventLoop eventLoop, ICompletionStage<V> input) {
        IPromise result = eventLoop.newPromise();
        FutureUtils.setFutureAsync((Executor)eventLoop, result, input, 524288);
        return result;
    }

    public static boolean await(CompletableFuture<?> future, long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout <= 0L) {
            return future.isDone();
        }
        if (future.isDone()) {
            return true;
        }
        try {
            future.get(timeout, unit);
            return true;
        }
        catch (TimeoutException ignore) {
            return false;
        }
        catch (ExecutionException ignore) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean awaitUninterruptedly(CompletableFuture<?> future, long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            return future.isDone();
        }
        if (future.isDone()) {
            return true;
        }
        boolean interrupted = false;
        long endTime = System.nanoTime() + unit.toNanos(timeout);
        try {
            long remainNano = endTime - System.nanoTime();
            if (remainNano <= 0L) {
                boolean bl = false;
                return bl;
            }
            future.get(remainNano, TimeUnit.NANOSECONDS);
            boolean bl = true;
            return bl;
        }
        finally {
            if (interrupted) {
                ThreadUtils.recoveryInterrupted();
            }
        }
    }

    public static <V> IPromise<V> newPromise() {
        return new Promise();
    }

    public static <V> IPromise<V> newPromise(Executor executor) {
        return new Promise(executor);
    }

    public static <V> IFuture<V> completedFuture(V result) {
        return Promise.completedPromise(result);
    }

    public static <V> IFuture<V> completedFuture(V result, Executor executor) {
        return Promise.completedPromise(result, executor);
    }

    public static <V> IFuture<V> failedFuture(Throwable cause) {
        return Promise.failedPromise(cause);
    }

    public static <V> IFuture<V> failedFuture(Throwable cause, Executor executor) {
        return Promise.failedPromise(cause, executor);
    }

    public static FutureCombiner newCombiner() {
        return new FutureCombiner();
    }

    public static JDKFutureCombiner newJdkCombiner() {
        return new JDKFutureCombiner();
    }

    public static boolean inEventLoop(@Nullable Executor executor) {
        SingleThreadExecutor eventLoop;
        return executor instanceof SingleThreadExecutor && (eventLoop = (SingleThreadExecutor)executor).inEventLoop();
    }

    public static void ensureInEventLoop(SingleThreadExecutor eventLoop) {
        if (!eventLoop.inEventLoop()) {
            throw new GuardedOperationException("Must be called from EventLoop thread");
        }
    }

    public static void ensureInEventLoop(SingleThreadExecutor eventLoop, String msg) {
        if (!eventLoop.inEventLoop()) {
            throw new GuardedOperationException(msg);
        }
    }

    public static CachedTimeProvider newTimeProvider(EventLoop eventLoop) {
        return new EventLoopTimeProvider(eventLoop, System.currentTimeMillis());
    }

    public static CachedTimeProvider newTimeProvider(EventLoop eventLoop, long curTime) {
        return new EventLoopTimeProvider(eventLoop, curTime);
    }

    public static <T> IFuture<T> submit(IExecutor executor, @Nonnull TaskBuilder<T> builder) {
        IPromise promise = FutureUtils.newPromise(executor);
        PromiseTask<T> futureTask = PromiseTask.ofBuilder(builder, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static <V> IFuture<V> submitFunc(Executor executor, Callable<? extends V> task) {
        IPromise<V> promise = FutureUtils.newPromise(executor);
        PromiseTask<? extends V> futureTask = PromiseTask.ofFunction(task, null, 0, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static <V> IFuture<V> submitFunc(IExecutor executor, Callable<? extends V> task, int options) {
        IPromise<V> promise = FutureUtils.newPromise(executor);
        PromiseTask<? extends V> futureTask = PromiseTask.ofFunction(task, null, options, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static <V> IFuture<V> submitFunc(Executor executor, Function<? super IContext, ? extends V> task, IContext ctx) {
        IPromise<V> promise = FutureUtils.newPromise(executor);
        PromiseTask<? extends V> futureTask = PromiseTask.ofFunction(task, ctx, 0, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static <V> IFuture<V> submitFunc(IExecutor executor, Function<? super IContext, ? extends V> task, IContext ctx, int options) {
        IPromise<V> promise = FutureUtils.newPromise(executor);
        PromiseTask<? extends V> futureTask = PromiseTask.ofFunction(task, ctx, options, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static IFuture<?> submitAction(Executor executor, Runnable action) {
        IPromise promise = FutureUtils.newPromise(executor);
        PromiseTask futureTask = PromiseTask.ofAction(action, null, 0, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static IFuture<?> submitAction(IExecutor executor, Runnable action, int options) {
        IPromise promise = FutureUtils.newPromise(executor);
        PromiseTask futureTask = PromiseTask.ofAction(action, null, options, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static IFuture<?> submitAction(Executor executor, Consumer<? super IContext> task, IContext ctx) {
        IPromise promise = FutureUtils.newPromise(executor);
        PromiseTask futureTask = PromiseTask.ofAction(task, ctx, 0, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static IFuture<?> submitAction(IExecutor executor, Consumer<? super IContext> task, IContext ctx, int options) {
        IPromise promise = FutureUtils.newPromise(executor);
        PromiseTask futureTask = PromiseTask.ofAction(task, ctx, options, promise);
        executor.execute(futureTask);
        return promise;
    }

    public static void execute(Executor executor, Consumer<? super IContext> action, IContext ctx) {
        ITask futureTask = FutureUtils.toTask(action, ctx, 0);
        executor.execute(futureTask);
    }

    public static void execute(IExecutor executor, Consumer<? super IContext> action, IContext ctx, int options) {
        ITask futureTask = FutureUtils.toTask(action, ctx, options);
        executor.execute(futureTask);
    }

    public static <T> IFuture<T> callAsync(Executor executor, Callable<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return FutureUtils.submitFunc(executor, supplier);
    }

    public static <T> IFuture<T> supplyAsync(Executor executor, Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return FutureUtils.submitFunc(executor, supplier::get);
    }

    public static IFuture<?> anyOf(IFuture<?> futures) {
        return new FutureCombiner().addAll(futures).anyOf();
    }

    public static IFuture<?> allOf(IFuture<?> ... futures) {
        return new FutureCombiner().addAll(futures).selectAll();
    }

    public static ITask toTask(Runnable action, int options) {
        Objects.requireNonNull(action, "action");
        return new Task1(action, options);
    }

    public static ITask toTask(Consumer<? super IContext> action, IContext ctx, int options) {
        Objects.requireNonNull(action, "action");
        return new Task3(action, ctx, options);
    }

    @ThreadSafe
    private static class EventLoopTimeProvider
    implements CachedTimeProvider {
        private final EventLoop eventLoop;
        private volatile long time;

        private EventLoopTimeProvider(EventLoop eventLoop, long time) {
            this.eventLoop = eventLoop;
            this.setTime(time);
        }

        public void setTime(long curTime) {
            if (!this.eventLoop.inEventLoop()) {
                throw new GuardedOperationException("setTime from another thread");
            }
            this.time = curTime;
        }

        public long getTime() {
            return this.time;
        }

        public String toString() {
            return "EventLoopTimeProvider{curTime=" + this.time + "}";
        }
    }

    private static class Task1
    implements ITask {
        private Runnable action;
        private final int options;

        public Task1(Runnable action, int options) {
            this.action = action;
            this.options = options;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public void run() {
            Runnable action = this.action;
            this.action = null;
            action.run();
        }
    }

    private static class Task3
    implements ITask {
        private Consumer<? super IContext> action;
        private IContext ctx;
        private final int options;

        public Task3(Consumer<? super IContext> action, IContext ctx, int options) {
            this.action = action;
            this.ctx = ctx;
            this.options = options;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public void run() {
            Consumer<? super IContext> action = this.action;
            IContext ctx = this.ctx;
            this.action = null;
            this.ctx = null;
            if (ctx != null && ctx.cancelToken().isCancelling()) {
                return;
            }
            action.accept(ctx);
        }
    }
}

